/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.excel.util.Config;
import com.feilong.lib.excel.ognl.OgnlStack;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CellValueSetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellValueSetter.class);

    private CellValueSetter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void set(Sheet sheet, int rowIndex, int cellIndex, String dataName, OgnlStack stack) {
        Cell cell;
        if (dataName.equals("#")) {
            return;
        }
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        if ((cell = row.getCell(cellIndex)) == null) {
            cell = row.createCell(cellIndex);
        }
        if (dataName.startsWith("=")) {
            cell.setCellFormula(dataName.substring(1));
            return;
        }
        try {
            Object value = stack.getValue(dataName);
            CellValueSetter.set(cell, value);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private static void set(Cell cell, Object value) {
        if (value == null) {
            cell.setCellValue((String)null);
            return;
        }
        CellType cellType = cell.getCellType();
        if (value instanceof Date) {
            if (cellType != CellType.NUMERIC) {
                cell.setCellType(CellType.NUMERIC);
            }
            if (!DateUtil.isCellDateFormatted((Cell)cell)) {
                Workbook workbook = cell.getSheet().getWorkbook();
                CellStyle cellStyle = workbook.createCellStyle();
                if (cell.getCellStyle() == null) {
                    cellStyle.cloneStyleFrom(cell.getCellStyle());
                }
                cellStyle.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat(Config.get("date.pattern")));
                cell.setCellStyle(cellStyle);
            }
        }
        if (cellType == CellType.BLANK || cellType == CellType.ERROR || cellType == CellType.FORMULA || cellType == CellType.NUMERIC) {
            if (value instanceof Integer) {
                cell.setCellValue(new BigDecimal((Integer)value).doubleValue());
            } else if (value instanceof Long) {
                cell.setCellValue(new BigDecimal((Long)value).doubleValue());
            } else if (value instanceof Double) {
                cell.setCellValue(((Double)value).doubleValue());
            } else if (value instanceof BigDecimal) {
                cell.setCellValue(((BigDecimal)value).doubleValue());
            } else if (value instanceof Date) {
                cell.setCellValue((Date)value);
            } else if (cellType == CellType.NUMERIC) {
                try {
                    cell.setCellValue(Double.parseDouble(value.toString()));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                cell.setCellValue(value.toString());
            }
            return;
        }
        if (cellType == CellType.BOOLEAN) {
            if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            }
            return;
        }
        cell.setCellValue(value.toString());
    }
}

