/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.excel.writer.FormulaEvaluatorUtil;
import org.apache.poi.ss.usermodel.Cell;

class CellCoper {
    private CellCoper() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void copy(Cell oldCell, Cell newCell) {
        newCell.setCellStyle(oldCell.getCellStyle());
        switch (oldCell.getCellType()) {
            case STRING: {
                newCell.setCellValue(oldCell.getRichStringCellValue());
                break;
            }
            case NUMERIC: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case BLANK: {
                newCell.setBlank();
                break;
            }
            case BOOLEAN: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
            case FORMULA: {
                newCell.setCellFormula(oldCell.getCellFormula());
                break;
            }
        }
    }

    static void copy(Cell oldCell, Cell newCell, int rowOffset, int colOffset) {
        newCell.setCellStyle(oldCell.getCellStyle());
        switch (oldCell.getCellType()) {
            case STRING: {
                newCell.setCellValue(oldCell.getRichStringCellValue());
                break;
            }
            case NUMERIC: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case BLANK: {
                newCell.setBlank();
                break;
            }
            case BOOLEAN: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
            case FORMULA: {
                newCell.setCellFormula(FormulaEvaluatorUtil.offsetFormula(oldCell.getCellFormula(), rowOffset, colOffset));
                break;
            }
        }
    }
}

