/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.core.Validator;
import com.feilong.excel.definition.ExcelBlock;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.excel.definition.ExcelCellConditionStyle;
import com.feilong.excel.writer.BlockStyleSetter;
import com.feilong.excel.writer.CellStyleSetter;
import com.feilong.excel.writer.CellValueSetter;
import com.feilong.lib.excel.ognl.OgnlStack;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;

class BlockSimpleWriter {
    private BlockSimpleWriter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void write(Sheet sheet, ExcelBlock blockDefinition, OgnlStack stack, Map<String, CellStyle> styleMap) {
        if (Validator.isNotNullOrEmpty(styleMap)) {
            for (ExcelCellConditionStyle excelCellConditionStyle : blockDefinition.getStyles()) {
                Object obj = stack.getValue(excelCellConditionStyle.getCondition());
                if (obj == null || !(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
                int startRow = excelCellConditionStyle.getStartRow();
                int endRow = excelCellConditionStyle.getEndRow();
                int startCol = excelCellConditionStyle.getStartCol();
                int endCol = excelCellConditionStyle.getEndCol();
                String cellIndex = excelCellConditionStyle.getCellIndex();
                BlockStyleSetter.set(sheet, startRow, endRow, startCol, endCol, cellIndex, styleMap);
            }
        }
        for (ExcelCell excelCell : blockDefinition.getCells()) {
            String dataExpr = excelCell.getDataExpr();
            int row = excelCell.getRow();
            String dataName = excelCell.getDataName();
            int col = excelCell.getCol();
            CellValueSetter.set(sheet, row, col, dataExpr == null ? dataName : dataExpr, stack);
            if (!Validator.isNotNullOrEmpty(styleMap)) continue;
            for (ExcelCellConditionStyle excelCellConditionStyle : excelCell.getStyles()) {
                Object obj = stack.getValue(excelCellConditionStyle.getCondition());
                if (obj == null || !(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
                CellStyleSetter.set(sheet, row, col, styleMap.get(excelCellConditionStyle.getCellIndex()));
            }
        }
    }
}

