/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.reader;

import com.feilong.excel.definition.ExcelBlock;
import com.feilong.excel.definition.ExcelSheet;
import com.feilong.excel.reader.BlockReader;
import com.feilong.excel.reader.ReadStatus;
import com.feilong.lib.excel.ognl.OgnlStack;
import org.apache.poi.ss.usermodel.Workbook;

public class SheetReader {
    private static final int STATUS_DATA_COLLECTION_ERROR = 10;

    private SheetReader() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void readSheet(Workbook workbook, int sheetNo, ExcelSheet sheetDefinition, OgnlStack ognlStack, ReadStatus readStatus, boolean skipErrors) {
        int loopBlock = 0;
        int status = readStatus.getStatus();
        for (ExcelBlock excelBlock : sheetDefinition.getExcelBlocks()) {
            if ((!skipErrors || status != 10) && status != 0 || loopBlock >= 1 && excelBlock.isLoop()) continue;
            if (excelBlock.isLoop()) {
                ++loopBlock;
                BlockReader.readLoopBlock(workbook, sheetNo, excelBlock, ognlStack, readStatus);
                continue;
            }
            BlockReader.readSimpleBlock(workbook, sheetNo, excelBlock, ognlStack, readStatus);
        }
    }
}

