/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.ClassUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.lang.SystemUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.excel.DefaultExcelWriter;
import com.feilong.excel.ExcelDefinition;
import com.feilong.excel.ExcelDefinitionBuilder;
import com.feilong.excel.ExcelSheetMapBuilder;
import com.feilong.excel.ExcelWriter;
import com.feilong.excel.definition.ExcelSheet;
import com.feilong.excel.util.SheetNamesUtil;
import com.feilong.io.FileUtil;
import com.feilong.io.FilenameUtil;
import com.feilong.json.JsonUtil;
import com.feilong.lib.collection4.CollectionUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelWriteUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelWriteUtil.class);

    private ExcelWriteUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String write(String templateLocation, String sheetDefinitionLocation, String sheetName, Map<String, Object> beans, String outputFileName) {
        String[] sheetNames = null == sheetName ? null : ConvertUtil.toArray(sheetName);
        return ExcelWriteUtil.write(templateLocation, sheetDefinitionLocation, sheetNames, beans, outputFileName);
    }

    public static String write(String templateLocation, String sheetDefinitionLocation, String[] sheetNames, Map<String, Object> beans, String outputFileName) {
        Date beginDate = new Date();
        Validate.notBlank(templateLocation, "templateLocation can't be blank!", new Object[0]);
        Validate.notBlank(sheetDefinitionLocation, "sheetDefinitionLocation can't be blank!", new Object[0]);
        Map<String, ExcelSheet> sheetDefinitions = ExcelSheetMapBuilder.build(sheetDefinitionLocation);
        String useOutputFileName = ObjectUtil.defaultIfNullOrEmpty(outputFileName, ExcelWriteUtil.buildDefaultOutputFileName(templateLocation, sheetNames, sheetDefinitions));
        if (LOGGER.isDebugEnabled()) {
            Map<String, Object> map = ExcelWriteUtil.build(templateLocation, sheetDefinitionLocation, sheetNames, beans, useOutputFileName);
            LOGGER.debug("will write excel,params info:[{}]", (Object)JsonUtil.format(map));
        }
        FileOutputStream outputStream = FileUtil.getFileOutputStream(useOutputFileName);
        Validate.notNull(outputStream, "outputStream can't be null!", new Object[0]);
        ExcelWriter excelWriter = ExcelWriteUtil.buildExcelWriter(sheetDefinitions, sheetNames);
        excelWriter.write(templateLocation, outputStream, beans);
        if (LOGGER.isInfoEnabled()) {
            Map<String, Object> map = ExcelWriteUtil.buildMap(templateLocation, sheetDefinitionLocation, sheetNames, beans, useOutputFileName, beginDate);
            LOGGER.info("write [SUCCESS],params info:[{}]", (Object)JsonUtil.format(map));
        }
        return useOutputFileName;
    }

    private static String buildDefaultOutputFileName(String templateLocation, String[] sheetNames, Map<String, ExcelSheet> sheetDefinitions) {
        String pattern = SystemUtil.USER_HOME + "/feilong/excel/{}{}.{}";
        return Slf4jUtil.format(pattern, ExcelWriteUtil.buildFileName(sheetNames, sheetDefinitions), DateUtil.nowTimestamp(), FilenameUtil.getExtension(templateLocation));
    }

    private static String buildFileName(String[] sheetNames, Map<String, ExcelSheet> sheetDefinitions) {
        if (!SheetNamesUtil.isEmptyOrNullElement(sheetNames)) {
            return ConvertUtil.toString((Object[])sheetNames, " ");
        }
        if (sheetDefinitions.size() == 1) {
            List<String> list = ConvertUtil.toList(sheetDefinitions.keySet());
            String string = list.get(0);
            return ObjectUtil.defaultIfNullOrEmpty(string, "");
        }
        return "";
    }

    private static ExcelWriter buildExcelWriter(Map<String, ExcelSheet> sheetDefinitions, String[] sheetNames) {
        ExcelDefinition excelDefinition = ExcelDefinitionBuilder.build(sheetDefinitions, sheetNames);
        return new DefaultExcelWriter(excelDefinition);
    }

    private static Map<String, Integer> toDataInfo(Map<String, Object> beans) {
        if (Validator.isNullOrEmpty(beans)) {
            return Collections.emptyMap();
        }
        Map<String, Integer> map = MapUtil.newLinkedHashMap();
        for (Map.Entry<String, Object> entry : beans.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!ClassUtil.isInstance(value, Collection.class)) continue;
            map.put(key + " size", CollectionUtils.size(value));
        }
        return map;
    }

    private static Map<String, Object> buildMap(String templateLocation, String sheetDefinitionLocation, String[] sheetNames, Map<String, Object> beans, String outputFileName, Date beginDate) {
        Map<String, Object> map = ExcelWriteUtil.build(templateLocation, sheetDefinitionLocation, sheetNames, beans, outputFileName);
        map.put("useTime", DateUtil.formatDuration(beginDate));
        return map;
    }

    private static Map<String, Object> build(String templateLocation, String sheetDefinitionLocation, String[] sheetNames, Map<String, Object> beans, String outputFileName) {
        Map<String, Object> map = MapUtil.newLinkedHashMap();
        map.put("templateLocation", templateLocation);
        map.put("sheetDefinitionLocation", sheetDefinitionLocation);
        map.put("sheetName", sheetNames);
        map.put("outputFileName", outputFileName);
        map.put("data info", ExcelWriteUtil.toDataInfo(beans));
        return map;
    }
}

