/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel;

import com.feilong.core.DefaultRuntimeException;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.date.DateUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.excel.DefaultExcelReader;
import com.feilong.excel.ExcelDefinition;
import com.feilong.excel.ExcelDefinitionBuilder;
import com.feilong.excel.ExcelReader;
import com.feilong.excel.ExcelSheetMapBuilder;
import com.feilong.excel.definition.ExcelSheet;
import com.feilong.excel.reader.ReadStatus;
import com.feilong.io.InputStreamUtil;
import com.feilong.json.JsonUtil;
import com.feilong.lib.collection4.CollectionUtils;
import com.feilong.lib.collection4.MapUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReaderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelReaderUtil.class);

    private ExcelReaderUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> List<T> read(String excelLocation, String sheetDefinitionLocation, String sheetName, String dataName, int sheetNo) {
        return ExcelReaderUtil.read(excelLocation, ConvertUtil.toArray(sheetDefinitionLocation), sheetName, dataName, sheetNo);
    }

    public static Map<String, Object> readData(String excelLocation, String sheetDefinitionLocation, String sheetName, String dataName, int sheetNo) {
        ExcelReader excelReader = ExcelReaderUtil.build(sheetDefinitionLocation, sheetName);
        InputStream inputStream = InputStreamUtil.getInputStream(excelLocation);
        return ExcelReaderUtil.readData(excelReader, inputStream, dataName, sheetNo);
    }

    private static ExcelReader build(String sheetDefinitionLocation, String sheetName) {
        Map<String, ExcelSheet> sheetDefinitions = ExcelSheetMapBuilder.build(sheetDefinitionLocation);
        return ExcelReaderUtil.buildExcelReader(sheetDefinitions, sheetName);
    }

    private static <T> List<T> read(String excelLocation, String[] sheetDefinitionLocations, String sheetName, String dataName, int sheetNo) {
        Map<String, ExcelSheet> sheetDefinitions = ExcelSheetMapBuilder.build(sheetDefinitionLocations);
        ExcelReader excelReader = ExcelReaderUtil.buildExcelReader(sheetDefinitions, sheetName);
        InputStream inputStream = InputStreamUtil.getInputStream(excelLocation);
        return ExcelReaderUtil.read(excelReader, inputStream, dataName, sheetNo);
    }

    private static ExcelReader buildExcelReader(Map<String, ExcelSheet> sheetDefinitions, String ... sheetNames) {
        ExcelDefinition build = ExcelDefinitionBuilder.build(sheetDefinitions, sheetNames);
        return new DefaultExcelReader(build);
    }

    private static <T> List<T> read(ExcelReader excelReader, InputStream inputStream, String dataName, int sheetNo) {
        Date beginDate = new Date();
        Map<String, Object> beans = ExcelReaderUtil.readData(excelReader, inputStream, dataName, sheetNo);
        List<T> list = ExcelReaderUtil.loadData(beans, dataName);
        if (LOGGER.isInfoEnabled()) {
            Map<String, Object> map = MapUtil.newLinkedHashMap();
            map.put("dataName", dataName);
            map.put("sheetNo", sheetNo);
            map.put("list size", CollectionUtils.size(list));
            map.put("use time", DateUtil.formatDuration(beginDate));
            LOGGER.info("use time: [{}]", (Object)JsonUtil.format(map));
        }
        return list;
    }

    private static <T> List<T> loadData(Map<String, Object> beans, String dataName) {
        if (Validator.isNotNullOrEmpty(dataName)) {
            return (List)beans.get(dataName);
        }
        if (MapUtils.size(beans) == 1) {
            return (List)ConvertUtil.toList(beans.values()).get(0);
        }
        throw new DefaultRuntimeException("dataName:[{}],keys:[{}] can't be null/empty!", dataName, beans.keySet());
    }

    private static Map<String, Object> readData(ExcelReader excelReader, InputStream inputStream, String dataName, int sheetNo) {
        Map<String, Object> beans = MapUtil.newLinkedHashMap();
        ReadStatus readStatus = excelReader.readSheet(inputStream, sheetNo, beans);
        int status = readStatus.getStatus();
        if (status != 0) {
            List<Exception> exceptions = readStatus.getExceptions();
            String pattern = "read excel exception,readStatus:[{}],getMessage:[{}],and exceptions size is:[{}],first exception is:\n{}";
            String message = Slf4jUtil.format(pattern, readStatus.getStatus(), readStatus.getMessage(), exceptions.size(), exceptions.get(0).getStackTrace());
            throw new DefaultRuntimeException(message);
        }
        return beans;
    }
}

