/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.csv;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.csv.CsvWrite;
import com.feilong.csv.entity.BeanCsvConfig;
import com.feilong.csv.entity.CsvColumnEntity;
import com.feilong.csv.entity.CsvConfig;
import com.feilong.csv.handler.CsvColumnEntityListBuilder;
import com.feilong.csv.handler.CsvContentBuilder;
import com.feilong.csv.handler.DataListBuilder;
import com.feilong.io.IOWriteUtil;
import com.feilong.lib.collection4.IterableUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCsvWrite
implements CsvWrite {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCsvWrite.class);
    private static final CsvConfig DEFAULT_CSV_CONFIG = new CsvConfig();

    @Override
    public <T> void write(String fileName, Iterable<T> iterable) {
        Validate.notBlank(fileName, "fileName can't be null/empty!", new Object[0]);
        Validate.isTrue(Validator.isNotNullOrEmpty(iterable), "iterable can't be null/empty!", new Object[0]);
        this.write(fileName, iterable, null);
    }

    @Override
    public <T> void write(String fileName, Iterable<T> iterable, BeanCsvConfig<T> beanCsvConfig) {
        Validate.notBlank(fileName, "fileName can't be null/empty!", new Object[0]);
        Validate.isTrue(Validator.isNotNullOrEmpty(iterable), "iterable can't be null/empty!", new Object[0]);
        BeanCsvConfig<T> useBeanCsvConfig = ObjectUtil.defaultIfNull(beanCsvConfig, DefaultCsvWrite.buildBeanCsvConfig(iterable));
        Validate.notNull(useBeanCsvConfig.getBeanClass(), "beanCsvConfig.getBeanClass() can't be null!", new Object[0]);
        List<CsvColumnEntity> csvColumnEntityList = CsvColumnEntityListBuilder.build(useBeanCsvConfig);
        String[] columnTitles = ConvertUtil.toStrings(CollectionsUtil.getPropertyValueList(csvColumnEntityList, "name"));
        List<Object[]> dataList = DataListBuilder.build(iterable, csvColumnEntityList);
        this.write(fileName, columnTitles, dataList, useBeanCsvConfig);
    }

    @Override
    public void write(String fileName, String[] columnTitles, List<Object[]> dataList) {
        Validate.notBlank(fileName, "fileName can't be null/empty!", new Object[0]);
        this.write(fileName, columnTitles, dataList, null);
    }

    @Override
    public void write(String fileName, String[] columnTitles, List<Object[]> dataList, CsvConfig csvConfig) {
        Validate.notBlank(fileName, "fileName can't be null/empty!", new Object[0]);
        Validate.isTrue(Validator.isNotNullOrEmpty(columnTitles) || Validator.isNotNullOrEmpty(dataList), "columnTitles and dataList can't all null!", new Object[0]);
        CsvConfig useCsvConfig = ObjectUtil.defaultIfNull(csvConfig, DEFAULT_CSV_CONFIG);
        List allLines = ObjectUtil.defaultIfNull(dataList, new ArrayList());
        if (Validator.isNotNullOrEmpty(columnTitles) && useCsvConfig.getIsPrintHeaderLine()) {
            allLines.add(0, columnTitles);
        }
        LOGGER.info("begin write file:[{}]", (Object)fileName);
        String content = CsvContentBuilder.build(allLines, useCsvConfig);
        IOWriteUtil.writeStringToFile(fileName, content, useCsvConfig.getEncode());
    }

    private static <T> BeanCsvConfig<T> buildBeanCsvConfig(Iterable<T> iterable) {
        T t = IterableUtils.get(iterable, 0);
        Class<?> klass = t.getClass();
        return new BeanCsvConfig(klass);
    }
}

