/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.coreextension.awt;

import com.feilong.coreextension.awt.ClipboardException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClipboardUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClipboardUtil.class);

    private ClipboardUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static final void setClipboardContent(CharSequence data) {
        if (null == data) {
            return;
        }
        Clipboard clipboard = ClipboardUtil.getSystemClipboard();
        StringSelection transferable = new StringSelection(data.toString());
        ClipboardOwner clipboardOwner = null;
        clipboard.setContents(transferable, clipboardOwner);
        LOGGER.debug("Clipboard setContents over,clipboardOwner[null]");
    }

    public static final String getClipboardContent() {
        Transferable transferable = ClipboardUtil.getTransferable();
        DataFlavor dataFlavor = DataFlavor.stringFlavor;
        if (transferable != null && transferable.isDataFlavorSupported(dataFlavor)) {
            try {
                return (String)transferable.getTransferData(dataFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                throw new ClipboardException(e);
            }
        }
        return null;
    }

    public static final Reader getClipboardReader() {
        Transferable transferable = ClipboardUtil.getTransferable();
        DataFlavor dataFlavor = DataFlavor.stringFlavor;
        try {
            return dataFlavor.getReaderForText(transferable);
        }
        catch (UnsupportedFlavorException | IOException e) {
            throw new ClipboardException(e);
        }
    }

    private static Transferable getTransferable() {
        Clipboard clipboard = ClipboardUtil.getSystemClipboard();
        Object requestor = null;
        return clipboard.getContents(requestor);
    }

    private static final Clipboard getSystemClipboard() {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        return defaultToolkit.getSystemClipboard();
    }
}

