/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util.predicate;

import com.feilong.core.Validate;
import com.feilong.core.bean.PropertyUtil;
import org.apache.commons.collections4.Predicate;

public class BeanPredicate<T>
implements Predicate<T> {
    private final String propertyName;
    private final Predicate valuePredicate;

    public BeanPredicate(String propertyName, Predicate valuePredicate) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        Validate.notNull(valuePredicate, "predicate can't be null!", new Object[0]);
        this.propertyName = propertyName;
        this.valuePredicate = valuePredicate;
    }

    @Override
    public boolean evaluate(T object) {
        Object currentPropertyValue = PropertyUtil.getProperty(object, this.propertyName);
        return this.valuePredicate.evaluate(currentPropertyValue);
    }
}

