/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util.comparator;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.core.util.comparator.ComparatorUtil;
import com.feilong.core.util.comparator.PropertyComparator;
import com.feilong.core.util.comparator.SortHelper;
import com.feilong.lib.beanutils.BeanComparator;
import com.feilong.lib.collection4.ComparatorUtils;
import com.feilong.lib.collection4.comparators.ComparableComparator;
import com.feilong.lib.collection4.comparators.FixedOrderComparator;
import java.util.Comparator;
import java.util.List;

public final class BeanComparatorUtil {
    private BeanComparatorUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> Comparator<T> chainedComparator(String ... propertyNameAndOrders) {
        Validate.notEmpty(propertyNameAndOrders, "propertyNameAndOrders can't be null/empty!", new Object[0]);
        if (1 == propertyNameAndOrders.length) {
            return BeanComparatorUtil.propertyComparator(propertyNameAndOrders[0]);
        }
        List comparators = CollectionsUtil.newArrayList();
        for (String propertyNameAndOrder : propertyNameAndOrders) {
            Validate.notBlank(propertyNameAndOrder, "propertyNameAndOrder can't be blank!", new Object[0]);
            String[] propertyNameAndOrderArray = SortHelper.parsePropertyNameAndOrder(propertyNameAndOrder);
            ComparableComparator comparableComparator = ComparableComparator.comparableComparator();
            Comparator instance = ComparatorUtils.nullHighComparator(comparableComparator);
            BeanComparator beanComparator = new BeanComparator(propertyNameAndOrderArray[0], instance);
            comparators.add(SortHelper.isAsc(propertyNameAndOrderArray) ? beanComparator : ComparatorUtils.reversedComparator(beanComparator));
        }
        return ComparatorUtils.chainedComparator(comparators);
    }

    public static <T> Comparator<T> propertyComparator(String propertyNameAndOrder) {
        Validate.notBlank(propertyNameAndOrder, "propertyNameAndOrder can't be blank!", new Object[0]);
        String[] propertyNameAndOrderArray = SortHelper.parsePropertyNameAndOrder(propertyNameAndOrder);
        PropertyComparator propertyComparator = new PropertyComparator(propertyNameAndOrderArray[0]);
        return SortHelper.isAsc(propertyNameAndOrderArray) ? propertyComparator : ComparatorUtils.reversedComparator(propertyComparator);
    }

    @SafeVarargs
    public static <T, V> Comparator<T> propertyComparator(String propertyName, V ... propertyValues) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        Validate.notNull(propertyValues, "propertyValues can't be null!", new Object[0]);
        return BeanComparatorUtil.propertyComparator(propertyName, ConvertUtil.toList(propertyValues));
    }

    public static <T, V> Comparator<T> propertyComparator(String propertyName, List<V> propertyValues) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        Validate.notNull(propertyValues, "propertyValues can't be null!", new Object[0]);
        return BeanComparatorUtil.propertyComparator(propertyName, propertyValues, FixedOrderComparator.UnknownObjectBehavior.AFTER);
    }

    public static <T, V> Comparator<T> propertyComparator(String propertyName, List<V> propertyValues, FixedOrderComparator.UnknownObjectBehavior unknownObjectBehavior) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        Validate.notNull(propertyValues, "propertyValues can't be null!", new Object[0]);
        FixedOrderComparator<V> fixedOrderComparator = ComparatorUtil.buildFixedOrderComparator(propertyValues, unknownObjectBehavior);
        return new PropertyComparator(propertyName, fixedOrderComparator);
    }
}

