/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.BeanUtil;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.lang.reflect.ConstructorUtil;
import com.feilong.core.text.MessageFormatUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceBundleUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleUtil.class);

    private ResourceBundleUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String getValue(ResourceBundle resourceBundle, String key, Object ... arguments) {
        Validate.notNull(resourceBundle, "resourceBundle can't be null!", new Object[0]);
        Validate.notBlank(key, "key can't be null/empty!", new Object[0]);
        if (!resourceBundle.containsKey(key)) {
            LOGGER.warn("resourceBundle:[{}] don't containsKey:[{}]", (Object)resourceBundle, (Object)key);
            return "";
        }
        String value = resourceBundle.getString(key);
        if (Validator.isNullOrEmpty(value)) {
            LOGGER.trace("resourceBundle has key:[{}],but value is null/empty", (Object)key);
        }
        return Validator.isNullOrEmpty(value) ? "" : MessageFormatUtil.format(value, arguments);
    }

    public static Map<String, String> toMap(String ... baseNames) {
        Validate.notEmpty(baseNames, "baseNames can't be null/empty!", new Object[0]);
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String baseName : baseNames) {
            Validate.notBlank(baseName, "baseName is null or empty,[%s]", ConvertUtil.toString((Object[])baseNames, ","));
            try {
                ResourceBundle resourceBundle = ResourceBundleUtil.getResourceBundle(baseName);
                Map<String, String> littleMap = ResourceBundleUtil.toMap(resourceBundle);
                if (!Validator.isNotNullOrEmpty(littleMap)) continue;
                map.putAll(littleMap);
            }
            catch (Exception e) {
                LOGGER.warn("baseName:[{}],message:[{}],ignore~", (Object)baseName, (Object)e.getMessage());
            }
        }
        return map;
    }

    public static Map<String, String> toMap(ResourceBundle resourceBundle) {
        Validate.notNull(resourceBundle, "resourceBundle can't be null!", new Object[0]);
        Enumeration<String> keysEnumeration = resourceBundle.getKeys();
        if (Validator.isNullOrEmpty(keysEnumeration)) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        while (keysEnumeration.hasMoreElements()) {
            String key = keysEnumeration.nextElement();
            map.put(key, resourceBundle.getString(key));
        }
        return map;
    }

    public static Properties toProperties(ResourceBundle resourceBundle) {
        return ConvertUtil.toProperties(ResourceBundleUtil.toMap(resourceBundle));
    }

    public static <T> T toAliasBean(ResourceBundle resourceBundle, Class<T> aliasBeanClass) {
        Validate.notNull(resourceBundle, "resourceBundle can't be null/empty!", new Object[0]);
        Validate.notNull(aliasBeanClass, "aliasBeanClass can't be null!", new Object[0]);
        return BeanUtil.populateAliasBean(ConstructorUtil.newInstance(aliasBeanClass, new Object[0]), ResourceBundleUtil.toMap(resourceBundle));
    }

    public static ResourceBundle getResourceBundle(String baseName) {
        return ResourceBundleUtil.getResourceBundle(baseName, null);
    }

    public static ResourceBundle getResourceBundle(String baseName, Locale locale) {
        Validate.notBlank(baseName, "baseName can't be null/empty!", new Object[0]);
        return ResourceBundle.getBundle(baseName, ObjectUtil.defaultIfNull(locale, Locale.getDefault()));
    }

    public static ResourceBundle getResourceBundle(InputStream inputStream) {
        Validate.notNull(inputStream, "inputStream can't be null!", new Object[0]);
        try {
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(inputStream);
            return propertyResourceBundle;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }
}

