/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.core.lang.NumberUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.lib.collection4.IterableUtils;
import com.feilong.lib.collection4.MapUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapUtil.class);

    private MapUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <K, V> Map.Entry<K, V> get(Map<K, V> map, int index) {
        Validate.notNull(map, "map can't be null!", new Object[0]);
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        return IterableUtils.get(entrySet, index);
    }

    public static <K, V> Map<K, V> toSingleValueMap(Map<K, V[]> arrayValueMap) {
        if (Validator.isNullOrEmpty(arrayValueMap)) {
            return Collections.emptyMap();
        }
        Map<K, Object> singleValueMap = MapUtil.newLinkedHashMap(arrayValueMap.size());
        for (Map.Entry<K, V[]> entry : arrayValueMap.entrySet()) {
            singleValueMap.put(entry.getKey(), null == entry.getValue() ? null : (Object)entry.getValue()[0]);
        }
        return singleValueMap;
    }

    public static <K> Map<K, String[]> toArrayValueMap(Map<K, String> singleValueMap) {
        if (Validator.isNullOrEmpty(singleValueMap)) {
            return Collections.emptyMap();
        }
        Map<K, String[]> arrayValueMap = MapUtil.newLinkedHashMap(singleValueMap.size());
        for (Map.Entry<K, String> entry : singleValueMap.entrySet()) {
            arrayValueMap.put(entry.getKey(), ConvertUtil.toArray(entry.getValue()));
        }
        return arrayValueMap;
    }

    public static <K, V> void putIfValueNotNull(Map<K, V> map, K key, V value) {
        if (null != map && null != value) {
            map.put(key, value);
        }
    }

    public static <K, V> void putAllIfNotNull(Map<K, V> map, Map<? extends K, ? extends V> m) {
        if (null != map && null != m) {
            map.putAll(m);
        }
    }

    public static <K, V> void putIfValueNotNullOrEmpty(Map<K, V> map, K key, V value) {
        if (null != map && Validator.isNotNullOrEmpty(value)) {
            map.put(key, value);
        }
    }

    public static <K> Map<K, Integer> putSumValue(Map<K, Integer> map, K key, Integer value) {
        Validate.notNull(map, "map can't be null!", new Object[0]);
        Validate.notNull(value, "value can't be null!", new Object[0]);
        Integer v = map.get(key);
        map.put(key, null == v ? value : value + v);
        return map;
    }

    public static <K> Map<K, BigDecimal> putSumValue(Map<K, BigDecimal> map, K key, Number value) {
        Validate.notNull(map, "map can't be null!", new Object[0]);
        Validate.notNull(value, "value can't be null!", new Object[0]);
        BigDecimal v = map.get(key);
        map.put(key, null == v ? ConvertUtil.toBigDecimal(value) : NumberUtil.getAddValue(value, v));
        return map;
    }

    public static <K, V> Map<K, List<V>> putMultiValue(Map<K, List<V>> map, K key, V value) {
        Validate.notNull(map, "map can't be null!", new Object[0]);
        List list = ObjectUtil.defaultIfNull(map.get(key), new ArrayList());
        list.add(value);
        map.put(key, list);
        return map;
    }

    @SafeVarargs
    public static <K, T> Map<K, T> getSubMap(Map<K, T> map, K ... keys) {
        if (Validator.isNullOrEmpty(keys)) {
            return map;
        }
        return MapUtil.getSubMap(map, ConvertUtil.toSet(keys));
    }

    public static <K, T> Map<K, T> getSubMap(Map<K, T> map, Iterable<K> keys) {
        if (Validator.isNullOrEmpty(map)) {
            return Collections.emptyMap();
        }
        if (Validator.isNullOrEmpty(keys)) {
            return map;
        }
        Map<K, T> returnMap = MapUtil.newLinkedHashMap(10);
        for (K key : keys) {
            if (map.containsKey(key)) {
                returnMap.put(key, map.get(key));
                continue;
            }
            LOGGER.debug("map has keys:[{}],but don't contains key:[{}]", map.keySet(), key);
        }
        return returnMap;
    }

    @SafeVarargs
    public static <K, T> Map<K, T> getSubMapExcludeKeys(Map<K, T> map, K ... excludeKeys) {
        if (Validator.isNullOrEmpty(excludeKeys)) {
            return map;
        }
        return MapUtil.getSubMapExcludeKeys(map, ConvertUtil.toSet(excludeKeys));
    }

    public static <K, T> Map<K, T> getSubMapExcludeKeys(Map<K, T> map, Iterable<K> excludeKeys) {
        if (Validator.isNullOrEmpty(map)) {
            return Collections.emptyMap();
        }
        if (Validator.isNullOrEmpty(excludeKeys)) {
            return map;
        }
        Map<K, T> returnMap = MapUtil.newLinkedHashMap(map.size());
        for (Map.Entry<K, T> entry : map.entrySet()) {
            K key = entry.getKey();
            if (IterableUtils.contains(excludeKeys, key)) continue;
            returnMap.put(key, entry.getValue());
        }
        return returnMap;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> removeKeys(Map<K, V> map, K ... keys) {
        if (null == map) {
            return null;
        }
        if (Validator.isNullOrEmpty(keys)) {
            return map;
        }
        for (K key : keys) {
            if (map.containsKey(key)) {
                map.remove(key);
                continue;
            }
            LOGGER.debug("map has keys:[{}],but don't contains key:[{}]", map.keySet(), key);
        }
        return map;
    }

    public static <K, V> Map<V, K> invertMap(Map<K, V> map) {
        return null == map ? null : MapUtils.invertMap(map);
    }

    public static <K, O, V> Map<K, V> extractSubMap(Map<K, O> map, String extractPropertyName) {
        return MapUtil.extractSubMap(map, null, extractPropertyName);
    }

    public static <K, O, V> Map<K, V> extractSubMap(Map<K, O> map, K[] includeKeys, String extractPropertyName) {
        if (Validator.isNullOrEmpty(map)) {
            return Collections.emptyMap();
        }
        Validate.notBlank(extractPropertyName, "extractPropertyName can't be null/empty!", new Object[0]);
        K[] useIncludeKeys = Validator.isNullOrEmpty(includeKeys) ? map.keySet().toArray() : includeKeys;
        Validate.notEmpty(useIncludeKeys, "useIncludeKeys can't be null/empty!", new Object[0]);
        Map returnMap = MapUtil.newLinkedHashMap(useIncludeKeys.length);
        for (K key : useIncludeKeys) {
            if (map.containsKey(key)) {
                returnMap.put(key, PropertyUtil.getProperty(map.get(key), extractPropertyName));
                continue;
            }
            LOGGER.warn("map:[{}] don't contains key:[{}]", map.keySet(), key);
        }
        return returnMap;
    }

    public static <K, V> Map<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> Map<K, V> newConcurrentHashMap(Map<K, V> map) {
        Validate.notNull(map, "map can't be null!", new Object[0]);
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newConcurrentHashMap(int expectedSize) {
        return new ConcurrentHashMap(MapUtil.toInitialCapacity(expectedSize));
    }

    public static <K extends Comparable, V> Map<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K extends Comparable, V> Map<K, V> newTreeMap(Map<K, V> map) {
        Validate.notNull(map, "map can't be null!", new Object[0]);
        return new TreeMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(Map<K, V> map) {
        Validate.notNull(map, "map can't be null!", new Object[0]);
        return new HashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newHashMap(int expectedSize) {
        return new HashMap(MapUtil.toInitialCapacity(expectedSize));
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap(Map<K, V> map) {
        Validate.notNull(map, "map can't be null!", new Object[0]);
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newLinkedHashMap(int expectedSize) {
        return new LinkedHashMap(MapUtil.toInitialCapacity(expectedSize));
    }

    private static int toInitialCapacity(int size) {
        Validate.isTrue(size >= 0, "size :[%s] must >=0", size);
        return (int)((float)size / 0.75f) + 1;
    }
}

