/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.net;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.ArrayUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.net.URIUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.core.util.SortUtil;
import com.feilong.lib.lang3.ArrayUtils;
import com.feilong.lib.lang3.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParamUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParamUtil.class);

    private ParamUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String addParameter(String uriString, String paramName, String paramValue, String charsetType) {
        return ParamUtil.addParameterSingleValueMap(uriString, ConvertUtil.toMap(paramName, paramValue), charsetType);
    }

    public static String addParameterSingleValueMap(String uriString, Map<String, String> singleValueMap, String charsetType) {
        return ParamUtil.addParameterArrayValueMap(uriString, MapUtil.toArrayValueMap(singleValueMap), charsetType);
    }

    public static String addParameterArrayValueMap(String uriString, Map<String, String[]> arrayValueMap, String charsetType) {
        return ParamUtil.addParameterArrayValueMap(uriString, URIUtil.getQueryString(uriString), arrayValueMap, charsetType);
    }

    public static Map<String, String> toSingleValueMap(String queryString, String charsetType) {
        return MapUtil.toSingleValueMap(ParamUtil.toSafeArrayValueMap(queryString, charsetType));
    }

    static Map<String, String[]> toSafeArrayValueMap(String queryString, String charsetType) {
        if (Validator.isNullOrEmpty(queryString)) {
            return Collections.emptyMap();
        }
        String[] nameAndValueArray = StringUtil.split(queryString, "&");
        int length = nameAndValueArray.length;
        Map<String, String[]> safeArrayValueMap = MapUtil.newLinkedHashMap(length);
        for (int i = 0; i < length; ++i) {
            String[] tempArray = nameAndValueArray[i].split("=", 2);
            String key = ParamUtil.decodeAndEncode(tempArray[0], charsetType);
            String value = tempArray.length == 2 ? tempArray[1] : "";
            value = ParamUtil.decodeAndEncode(value, charsetType);
            safeArrayValueMap.put(key, ArrayUtils.add((Object[])safeArrayValueMap.get(key), value));
        }
        return safeArrayValueMap;
    }

    public static String toNaturalOrderingKeyJoinValue(Map<String, String> singleValueMap) {
        if (Validator.isNullOrEmpty(singleValueMap)) {
            return "";
        }
        Map<String, String> sortMapByKeyAsc = SortUtil.sortMapByKeyAsc(singleValueMap);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : sortMapByKeyAsc.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(StringUtils.defaultString(key));
            sb.append(StringUtils.defaultString(value));
        }
        return sb.toString();
    }

    public static String toNaturalOrderingJoinValue(Map<String, String> singleValueMap) {
        if (Validator.isNullOrEmpty(singleValueMap)) {
            return "";
        }
        Map<String, String> sortMapByKeyAsc = SortUtil.sortMapByKeyAsc(singleValueMap);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : sortMapByKeyAsc.entrySet()) {
            String value = entry.getValue();
            sb.append(StringUtils.defaultString(value));
        }
        return sb.toString();
    }

    public static String toNaturalOrderingQueryString(Map<String, String> singleValueMap) {
        return Validator.isNullOrEmpty(singleValueMap) ? "" : ParamUtil.toQueryStringUseSingleValueMap(SortUtil.sortMapByKeyAsc(singleValueMap));
    }

    public static String toQueryStringUseSingleValueMap(Map<String, String> singleValueMap) {
        return ParamUtil.toQueryStringUseArrayValueMap(MapUtil.toArrayValueMap(singleValueMap));
    }

    public static String toQueryStringUseArrayValueMap(Map<String, String[]> arrayValueMap) {
        if (Validator.isNullOrEmpty(arrayValueMap)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : arrayValueMap.entrySet()) {
            sb.append(ParamUtil.joinParamNameAndValues(entry.getKey(), entry.getValue()));
            sb.append("&");
        }
        return StringUtil.substringWithoutLast(sb, "&");
    }

    private static String joinParamNameAndValues(String paramName, String[] paramValues) {
        if (null == paramValues) {
            return StringUtils.defaultString(paramName) + "=";
        }
        StringBuilder sb = new StringBuilder();
        for (String paramValue : paramValues) {
            sb.append(StringUtils.defaultString(paramName)).append("=").append(StringUtils.defaultString(paramValue));
            sb.append("&");
        }
        return StringUtil.substringWithoutLast(sb, "&");
    }

    @SafeVarargs
    public static <K> String joinValuesOrderByIncludeKeys(Map<K, String> singleValueMap, K ... includeKeys) {
        Validate.notNull(singleValueMap, "singleValueMap can't be null!", new Object[0]);
        if (Validator.isNullOrEmpty(includeKeys)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (K key : includeKeys) {
            sb.append(StringUtils.defaultString(singleValueMap.get(key)));
        }
        return sb.toString();
    }

    static String addParameterArrayValueMap(String uriString, String queryString, Map<String, String[]> arrayValueMap, String charsetType) {
        Map safeArrayValueMap = ObjectUtil.defaultIfNull(arrayValueMap, Collections.emptyMap());
        Map<String, String[]> arrayParamValuesMap = MapUtil.newLinkedHashMap(safeArrayValueMap.size());
        if (Validator.isNotNullOrEmpty(queryString)) {
            arrayParamValuesMap.putAll(ParamUtil.toSafeArrayValueMap(queryString, null));
        }
        arrayParamValuesMap.putAll(safeArrayValueMap);
        return ParamUtil.combineUrl(URIUtil.getFullPathWithoutQueryString(uriString), arrayParamValuesMap, charsetType);
    }

    private static Map<String, String[]> toSafeArrayValueMap(Map<String, String[]> arrayValueMap, String charsetType) {
        if (Validator.isNullOrEmpty(arrayValueMap)) {
            return Collections.emptyMap();
        }
        Map<String, String[]> safeArrayValueMap = MapUtil.newLinkedHashMap(arrayValueMap.size());
        for (Map.Entry<String, String[]> entry : arrayValueMap.entrySet()) {
            String key = entry.getKey();
            String[] paramValues = entry.getValue();
            if (Validator.isNullOrEmpty(paramValues)) {
                LOGGER.warn("the param key:[{}] value is null", (Object)key);
                paramValues = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            safeArrayValueMap.put(ParamUtil.decodeAndEncode(key, charsetType), ParamUtil.toSafeValueArray(paramValues, charsetType));
        }
        return safeArrayValueMap;
    }

    private static String[] toSafeValueArray(String[] paramValues, String charsetType) {
        if (Validator.isNullOrEmpty(charsetType)) {
            return paramValues;
        }
        List<String> paramValueList = CollectionsUtil.newArrayList();
        for (String value : paramValues) {
            paramValueList.add(ParamUtil.decodeAndEncode(value, charsetType));
        }
        return ConvertUtil.toArray(paramValueList, String.class);
    }

    private static String decodeAndEncode(String value, String charsetType) {
        if (Validator.isNullOrEmpty(value)) {
            return "";
        }
        return Validator.isNullOrEmpty(charsetType) ? value : URIUtil.encode(URIUtil.decode(value, charsetType), charsetType);
    }

    static String combineUrl(String beforePathWithoutQueryString, Map<String, String[]> arrayValueMap, String charsetType) {
        if (Validator.isNullOrEmpty(beforePathWithoutQueryString)) {
            return "";
        }
        if (Validator.isNullOrEmpty(arrayValueMap)) {
            return beforePathWithoutQueryString;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(beforePathWithoutQueryString);
        sb.append("?");
        sb.append(ParamUtil.toQueryStringUseArrayValueMap(ParamUtil.toSafeArrayValueMap(arrayValueMap, charsetType)));
        return sb.toString();
    }
}

