/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang.thread;

import com.feilong.core.Validate;
import com.feilong.core.lang.ThreadUtil;
import com.feilong.core.lang.thread.AbstractPartitionThreadExecutor;
import com.feilong.core.lang.thread.PartitionRunnableBuilder;
import com.feilong.core.lang.thread.PartitionThreadEntity;
import com.feilong.core.lang.thread.PartitionThreadExecutor;
import com.feilong.lib.collection4.ListUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartitionThreadExecutor
extends AbstractPartitionThreadExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPartitionThreadExecutor.class);
    public static final PartitionThreadExecutor INSTANCE = new DefaultPartitionThreadExecutor();

    @Override
    protected <T> void actualExecute(List<T> list, int eachSize, Map<String, ?> paramsMap, PartitionRunnableBuilder<T> partitionRunnableBuilder) {
        Thread[] threads = DefaultPartitionThreadExecutor.buildThreadArray(list, eachSize, paramsMap, partitionRunnableBuilder);
        ThreadUtil.startAndJoin(threads);
    }

    private static <T> Thread[] buildThreadArray(List<T> list, int eachSize, Map<String, ?> paramsMap, PartitionRunnableBuilder<T> partitionRunnableBuilder) {
        ThreadGroup threadGroup = new ThreadGroup(DefaultPartitionThreadExecutor.buildThreadGroupName(list, partitionRunnableBuilder));
        List<List<T>> groupList = ListUtils.partition(list, eachSize);
        int i = 0;
        Thread[] threads = new Thread[groupList.size()];
        for (List<T> perBatchList : groupList) {
            String threadName = DefaultPartitionThreadExecutor.buildThreadName(i, partitionRunnableBuilder);
            PartitionThreadEntity partitionThreadEntity = new PartitionThreadEntity(threadName, list.size(), eachSize, i, perBatchList.size());
            Runnable runnable = partitionRunnableBuilder.build(perBatchList, partitionThreadEntity, paramsMap);
            threads[i] = new Thread(threadGroup, runnable, threadName);
            ++i;
        }
        LOGGER.info("total list size:[{}],build [{}] threads,perSize:[{}]", new Object[]{list.size(), threads.length, eachSize});
        return threads;
    }

    private static <T> String buildThreadGroupName(List<T> list, PartitionRunnableBuilder<T> partitionRunnableBuilder) {
        Validate.notNull(partitionRunnableBuilder, "partitionRunnableBuilder can't be null!", new Object[0]);
        return Slf4jUtil.format("ThreadGroup-{}-{}", DefaultPartitionThreadExecutor.getName(partitionRunnableBuilder), list.size());
    }

    private static <T> String buildThreadName(int batchNumber, PartitionRunnableBuilder<T> partitionRunnableBuilder) {
        Validate.notNull(partitionRunnableBuilder, "partitionRunnableBuilder can't be null!", new Object[0]);
        return Slf4jUtil.format("Thread-{}-{}", DefaultPartitionThreadExecutor.getName(partitionRunnableBuilder), batchNumber);
    }
}

