/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang.thread;

import com.feilong.core.Validate;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.lang.thread.PartitionRunnableBuilder;
import com.feilong.core.lang.thread.PartitionThreadExecutor;
import com.feilong.lib.lang3.ClassUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPartitionThreadExecutor
implements PartitionThreadExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPartitionThreadExecutor.class);

    @Override
    public <T> void execute(List<T> list, int eachSize, PartitionRunnableBuilder<T> partitionRunnableBuilder) {
        this.execute(list, eachSize, null, partitionRunnableBuilder);
    }

    @Override
    public <T> void execute(List<T> list, int eachSize, Map<String, ?> paramsMap, PartitionRunnableBuilder<T> partitionRunnableBuilder) {
        Validate.notEmpty(list, "list can't be null/empty!", new Object[0]);
        Validate.notNull(partitionRunnableBuilder, "partitionRunnableBuilder can't be null!", new Object[0]);
        Validate.isTrue(eachSize > 0, "eachSize must > 0", new Object[0]);
        String partitionRunnableBuilderName = AbstractPartitionThreadExecutor.getName(partitionRunnableBuilder);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("begin [{}],list size:[{}],eachSize:[{}]", new Object[]{partitionRunnableBuilderName, list.size(), eachSize});
        }
        Date beginDate = DateUtil.now();
        this.actualExecute(list, eachSize, paramsMap, partitionRunnableBuilder);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("end [{}],use time:[{}]", (Object)partitionRunnableBuilderName, (Object)DateUtil.formatDuration(beginDate));
        }
    }

    protected abstract <T> void actualExecute(List<T> var1, int var2, Map<String, ?> var3, PartitionRunnableBuilder<T> var4);

    protected static <T> String getName(PartitionRunnableBuilder<T> partitionRunnableBuilder) {
        return ObjectUtil.defaultIfNullOrEmpty(ClassUtils.getSimpleName(partitionRunnableBuilder.getClass()), partitionRunnableBuilder.getClass().getName());
    }
}

