/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang.reflect;

import com.feilong.core.Validate;
import com.feilong.core.lang.ClassUtil;
import com.feilong.core.lang.reflect.ReflectException;
import com.feilong.lib.lang3.reflect.ConstructorUtils;
import com.feilong.tools.slf4j.Slf4jUtil;

public final class ConstructorUtil {
    private ConstructorUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> T newInstance(Class<T> klass, Object ... parameterValues) {
        Validate.notNull(klass, "klass can't be null!", new Object[0]);
        Class<?>[] parameterTypes = ClassUtil.toClass(parameterValues);
        return ConstructorUtil.newInstance(klass, parameterValues, parameterTypes);
    }

    public static <T> T newInstance(Class<T> klass, Object[] parameterValues, Class<?>[] parameterTypes) {
        Validate.notNull(klass, "klass can't be null!", new Object[0]);
        try {
            return ConstructorUtils.invokeConstructor(klass, parameterValues, parameterTypes);
        }
        catch (Exception e) {
            String pattern = "invokeConstructor exception,class:[{}].args:[{}],parameterTypes:[{}]";
            String message = Slf4jUtil.format(pattern, klass, parameterValues, parameterTypes);
            throw new ReflectException(message, e);
        }
    }
}

