/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang;

import com.feilong.core.Validate;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.thread.DefaultPartitionRunnableBuilder;
import com.feilong.core.lang.thread.DefaultPartitionThreadExecutor;
import com.feilong.core.lang.thread.PartitionEachSizeThreadConfigBuilder;
import com.feilong.core.lang.thread.PartitionPerHandler;
import com.feilong.core.lang.thread.PartitionRunnableBuilder;
import com.feilong.core.lang.thread.PartitionThreadConfig;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadUtil.class);

    private ThreadUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static final void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void execute(Runnable runnable, int threadCount) {
        Validate.notNull(runnable, "runnable can't be null!", new Object[0]);
        Validate.isTrue(threadCount > 0, "threadCount must > 0", new Object[0]);
        Date beginDate = DateUtil.now();
        Thread[] threads = ThreadUtil.buildThreadArray(runnable, threadCount);
        ThreadUtil.startAndJoin(threads);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("runnable:[{}],threadCount:[{}],total use time:{}", new Object[]{runnable, threadCount, DateUtil.formatDuration(beginDate)});
        }
    }

    private static Thread[] buildThreadArray(Runnable runnable, int threadCount) {
        Thread[] threads = new Thread[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            threads[i] = new Thread(runnable);
        }
        return threads;
    }

    public static <T> void execute(List<T> list, int eachSize, PartitionRunnableBuilder<T> partitionRunnableBuilder) {
        ThreadUtil.execute(list, eachSize, null, partitionRunnableBuilder);
    }

    public static <T> void execute(List<T> list, int eachSize, PartitionPerHandler<T> partitionPerHandler) {
        ThreadUtil.execute(list, eachSize, null, partitionPerHandler);
    }

    public static <T> void execute(List<T> list, int eachSize, Map<String, ?> paramsMap, PartitionRunnableBuilder<T> partitionRunnableBuilder) {
        DefaultPartitionThreadExecutor.INSTANCE.execute(list, eachSize, paramsMap, partitionRunnableBuilder);
    }

    public static <T> void execute(List<T> list, int eachSize, Map<String, ?> paramsMap, PartitionPerHandler<T> partitionPerHandler) {
        Validate.notNull(partitionPerHandler, "partitionPerHandler can't be null!", new Object[0]);
        ThreadUtil.execute(list, eachSize, paramsMap, new DefaultPartitionRunnableBuilder<T>(partitionPerHandler));
    }

    public static <T> void execute(List<T> list, PartitionThreadConfig partitionThreadConfig, Map<String, ?> paramsMap, PartitionPerHandler<T> partitionPerHandler) {
        Validate.notEmpty(list, "list can't be null/empty!", new Object[0]);
        Validate.notNull(partitionThreadConfig, "partitionConfig can't be null!", new Object[0]);
        Validate.notNull(partitionPerHandler, "partitionPerHandler can't be null!", new Object[0]);
        int eachSize = new PartitionEachSizeThreadConfigBuilder(partitionThreadConfig).build(list.size());
        ThreadUtil.execute(list, eachSize, paramsMap, new DefaultPartitionRunnableBuilder<T>(partitionPerHandler));
    }

    public static void startAndJoin(Thread[] threads) {
        Validate.notEmpty(threads, "threads can't be null/empty!", new Object[0]);
        for (Thread thread : threads) {
            thread.start();
            LOGGER.debug("thread [{}] start", (Object)thread.getName());
        }
        try {
            for (Thread thread : threads) {
                LOGGER.debug("begin thread [{}] join", (Object)thread.getName());
                thread.join();
                LOGGER.debug("end thread [{}] join", (Object)thread.getName());
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

