/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.net.URLUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassLoaderUtil.class);

    private ClassLoaderUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static URL getResource(String resourceName) {
        return ClassLoaderUtil.getResource(ClassLoaderUtil.getClassLoaderByClass(ClassLoaderUtil.class), resourceName);
    }

    private static URL getResource(ClassLoader classLoader, String resourceName) {
        Validate.notNull(classLoader, "classLoader can't be null!", new Object[0]);
        Validate.notNull(resourceName, "resourceName can't be null!", new Object[0]);
        boolean startsWithSlash = resourceName.startsWith("/");
        String usePath = startsWithSlash ? StringUtil.substring(resourceName, 1) : resourceName;
        URL result = classLoader.getResource(usePath);
        LOGGER.trace("search resource:[\"{}\"] in [{}],result:[{}]", new Object[]{resourceName, classLoader, result});
        return result;
    }

    public static InputStream getResourceAsStream(String resourceName, Class<?> callingClass) {
        URL url = ClassLoaderUtil.getResourceInAllClassLoader(resourceName, callingClass);
        return URLUtil.openStream(url);
    }

    public static URL getResourceInAllClassLoader(String resourceName, Class<?> callingClass) {
        Validate.notNull(resourceName, "resourceName can't be null!", new Object[0]);
        List<ClassLoader> classLoaderList = ClassLoaderUtil.getAllClassLoaderList(callingClass);
        for (ClassLoader classLoader : classLoaderList) {
            URL url = ClassLoaderUtil.getResource(classLoader, resourceName);
            if (null == url) {
                LOGGER.trace(ClassLoaderUtil.getLogInfo(resourceName, classLoader, false));
                continue;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(ClassLoaderUtil.getLogInfo(resourceName, classLoader, true));
            }
            return url;
        }
        LOGGER.debug("not found:[{}] in all ClassLoader,return null", (Object)resourceName);
        return null;
    }

    private static List<ClassLoader> getAllClassLoaderList(Class<?> callingClass) {
        List<ClassLoader> list = ConvertUtil.toList(ClassLoaderUtil.getClassLoaderByCurrentThread(), ClassLoaderUtil.getClassLoaderByClass(ClassLoaderUtil.class));
        if (null != callingClass) {
            list.add(ClassLoaderUtil.getClassLoaderByClass(callingClass));
        }
        return list;
    }

    private static ClassLoader getClassLoaderByCurrentThread() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("[Thread.currentThread()].getContextClassLoader:{}", (Object)ClassLoaderUtil.formatClassLoader(classLoader));
        }
        return classLoader;
    }

    private static ClassLoader getClassLoaderByClass(Class<?> callingClass) {
        Validate.notNull(callingClass, "callingClass can't be null!", new Object[0]);
        ClassLoader classLoader = callingClass.getClassLoader();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("[{}].getClassLoader():{}", (Object)callingClass.getSimpleName(), (Object)ClassLoaderUtil.formatClassLoader(classLoader));
        }
        return classLoader;
    }

    private static String getLogInfo(String resourceName, ClassLoader classLoader, boolean isFouned) {
        String message = "{}found [{}],in ClassLoader:[{}]";
        return Slf4jUtil.format(message, isFouned ? "" : "not ", resourceName, ClassLoaderUtil.formatClassLoader(classLoader));
    }

    private static String formatClassLoader(ClassLoader classLoader) {
        Map<String, String> map = MapUtil.newLinkedHashMap(2);
        map.put("classLoader[CanonicalName]", classLoader.getClass().getCanonicalName());
        map.put("classLoader[Root Classpath]", "" + ClassLoaderUtil.getResource(classLoader, ""));
        return map.toString();
    }
}

