/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.converter;

import com.feilong.context.converter.AbstractBeanClassStringToBeanConverter;
import com.feilong.context.converter.builder.BeanBuilder;
import com.feilong.context.converter.builder.NameAndValueMapBuilder;
import com.feilong.core.Validate;
import com.feilong.core.lang.reflect.ConstructorUtil;
import com.feilong.core.util.SortUtil;
import com.feilong.json.JsonUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapBuilderStringToBeanConverter<T>
extends AbstractBeanClassStringToBeanConverter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapBuilderStringToBeanConverter.class);
    private NameAndValueMapBuilder nameAndValueMapBuilder;
    private BeanBuilder beanBuilder;

    public MapBuilderStringToBeanConverter() {
        this(null, null);
    }

    public MapBuilderStringToBeanConverter(NameAndValueMapBuilder nameAndValueMapBuilder, BeanBuilder beanBuilder) {
        this.nameAndValueMapBuilder = nameAndValueMapBuilder;
        this.beanBuilder = beanBuilder;
    }

    @Override
    protected T handler(String inputString) {
        Validate.notNull(this.beanClass, "beanClass can't be null!", new Object[0]);
        Map<String, String> nameAndValueMap = this.nameAndValueMapBuilder.build(inputString);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("will build [{}], use data:{}", (Object)this.beanClass.getName(), (Object)JsonUtil.format(SortUtil.sortMapByKeyAsc(nameAndValueMap)));
        }
        return this.beanBuilder.build(nameAndValueMap, ConstructorUtil.newInstance(this.beanClass, new Object[0]));
    }

    public NameAndValueMapBuilder getNameAndValueMapBuilder() {
        return this.nameAndValueMapBuilder;
    }

    public void setNameAndValueMapBuilder(NameAndValueMapBuilder nameAndValueMapBuilder) {
        this.nameAndValueMapBuilder = nameAndValueMapBuilder;
    }

    public BeanBuilder getBeanBuilder() {
        return this.beanBuilder;
    }

    public void setBeanBuilder(BeanBuilder beanBuilder) {
        this.beanBuilder = beanBuilder;
    }
}

