/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.codecreator;

import com.feilong.context.codecreator.CodeCreatorHelper;
import com.feilong.context.codecreator.MultiSellerOrderCodeCreator;
import com.feilong.context.codecreator.SimpleMultiSellerOrderCodeCreatorConfig;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.util.RandomUtil;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.StringUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMultiSellerOrderCodeCreator
implements MultiSellerOrderCodeCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMultiSellerOrderCodeCreator.class);
    private SimpleMultiSellerOrderCodeCreatorConfig simpleMultiSellerOrderCodeCreatorConfig;

    @Override
    public String create(Long buyerId, Long sellerId) {
        return SimpleMultiSellerOrderCodeCreator.generatorCode(DateUtil.now(), buyerId, sellerId, this.simpleMultiSellerOrderCodeCreatorConfig);
    }

    private static String generatorCode(Date specifiedDate, Long buyerId, Long sellerId, SimpleMultiSellerOrderCodeCreatorConfig simpleMultiSellerOrderCodeCreatorConfig) {
        String prefix = simpleMultiSellerOrderCodeCreatorConfig.getPrefix();
        int buyerIdLastLength = simpleMultiSellerOrderCodeCreatorConfig.getBuyerIdLastLength();
        int shopIdLastLength = simpleMultiSellerOrderCodeCreatorConfig.getShopIdLastLength();
        String debugSeparator = CodeCreatorHelper.debugSeparator(simpleMultiSellerOrderCodeCreatorConfig.getIsDebug());
        String yy = DateUtil.toString(specifiedDate, "yy");
        String hourOfYear = StringUtil.format("%04d", DateUtil.getHourOfYear(specifiedDate));
        String mmss = DateUtil.toString(specifiedDate, "mmss");
        String randomString = "" + RandomUtil.createRandomWithLength(simpleMultiSellerOrderCodeCreatorConfig.getRandomNumberLength());
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.defaultString(prefix));
        sb.append(debugSeparator + yy);
        sb.append(debugSeparator + CodeCreatorHelper.formatLastValue(sellerId, shopIdLastLength));
        sb.append(debugSeparator + hourOfYear);
        sb.append(debugSeparator + CodeCreatorHelper.formatLastValue(buyerId, buyerIdLastLength));
        sb.append(debugSeparator + mmss);
        sb.append(debugSeparator + randomString);
        String result = sb.toString() + CodeCreatorHelper.debugLength(sb, simpleMultiSellerOrderCodeCreatorConfig.getIsDebug());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("[{}]-->[{}],buyerId:[{}],sellerId:[{}],simpleMultiSellerOrderCodeCreatorConfig:[{}] ", new Object[]{DateUtil.toString(specifiedDate, "yyyy-MM-dd HH:mm:ss.SSS"), result, buyerId, sellerId, JsonUtil.format(simpleMultiSellerOrderCodeCreatorConfig)});
        }
        return result;
    }

    public void setSimpleMultiSellerOrderCodeCreatorConfig(SimpleMultiSellerOrderCodeCreatorConfig simpleMultiSellerOrderCodeCreatorConfig) {
        this.simpleMultiSellerOrderCodeCreatorConfig = simpleMultiSellerOrderCodeCreatorConfig;
    }
}

