/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context;

import com.feilong.context.Condition;
import com.feilong.context.Task;
import com.feilong.context.log.UseTimeLogable;
import com.feilong.core.Validate;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionableTask<T>
implements Task<T>,
UseTimeLogable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConditionableTask.class);
    private Condition condition;
    private Task<T> task;

    @PostConstruct
    protected void postConstruct() {
        Validate.notNull(this.task, "job can't be null!", new Object[0]);
    }

    @Override
    public T run() {
        if (null != this.condition && !this.condition.canRun()) {
            LOGGER.info("condition:[{}] return can't run,return null.", (Object)this.condition.getClass().getName());
            return null;
        }
        String taskName = this.task.getClass().getName();
        if (null == this.condition) {
            LOGGER.debug("condition is null,will execute task:[{}].", (Object)taskName);
        } else {
            LOGGER.debug("condition:[{}] can run,will execute task:[{}].", (Object)this.condition.getClass().getName(), (Object)taskName);
        }
        T result = this.task.run();
        LOGGER.debug("task:[{}] run result:[{}]", (Object)taskName, result);
        return result;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void setTask(Task<T> task) {
        this.task = task;
    }
}

