/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.component;

import com.feilong.context.FileReworker;
import com.feilong.core.Validator;
import com.feilong.io.FilenameUtil;
import com.feilong.spring.expression.SpelUtil;
import com.feilong.zip.CompressZipHandler;
import com.feilong.zip.ZipHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileReworker
implements FileReworker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipFileReworker.class);
    private ZipHandler zipHandler = new CompressZipHandler();
    private String outputZipPathExpression;

    public ZipFileReworker(String outputZipPathExpression) {
        this.outputZipPathExpression = outputZipPathExpression;
    }

    public ZipFileReworker() {
    }

    public ZipFileReworker(ZipHandler zipHandler, String outputZipPathExpression) {
        this.zipHandler = zipHandler;
        this.outputZipPathExpression = outputZipPathExpression;
    }

    @Override
    public String rework(String filePath) {
        String zipFilePath = ZipFileReworker.build(filePath, this.outputZipPathExpression);
        LOGGER.debug("filePath:[{}],outputZipPathExpression:[{}],zipFilePath:[{}]", new Object[]{filePath, this.outputZipPathExpression, zipFilePath});
        this.zipHandler.zip(filePath, zipFilePath);
        return zipFilePath;
    }

    private static String build(String filePath, String outputZipPathExpression) {
        if (Validator.isNotNullOrEmpty(outputZipPathExpression)) {
            return (String)SpelUtil.getTemplateValue(outputZipPathExpression);
        }
        String newPostfixName = "zip";
        return FilenameUtil.getNewFileName(filePath, newPostfixName);
    }

    public void setOutputZipPathExpression(String outputZipPathExpression) {
        this.outputZipPathExpression = outputZipPathExpression;
    }

    public void setZipHandler(ZipHandler zipHandler) {
        this.zipHandler = zipHandler;
    }
}

