/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.component;

import com.feilong.component.Component;
import com.feilong.context.Data;
import com.feilong.context.DataListQuery;
import com.feilong.context.FileReworker;
import com.feilong.context.Task;
import com.feilong.context.filecreator.ListDataFileCreator;
import com.feilong.context.log.UseTimeLogable;
import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.BeanUtil;
import com.feilong.json.JsonUtil;
import com.feilong.net.mail.MailSender;
import com.feilong.net.mail.entity.MailSendRequest;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFileEmailComponent<T extends Data>
implements Task<Void>,
UseTimeLogable,
Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataFileEmailComponent.class);
    private DataListQuery<T> dataListQuery;
    private ListDataFileCreator<T> listDataFileCreator;
    private FileReworker fileReworker;
    private MailSender mailSender;
    private MailSendRequest mailSendRequest;

    @PostConstruct
    protected void postConstruct() {
        Validate.notNull(this.mailSender, "mailSender can't be null!", new Object[0]);
        Validate.notNull(this.mailSendRequest, "mailSenderConfig can't be null!", new Object[0]);
    }

    @Override
    public Void run() {
        List<T> dataList = this.dataListQuery.query();
        if (Validator.isNullOrEmpty(dataList)) {
            LOGGER.info("dataList is null or empty ,nothing to do");
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(JsonUtil.format(dataList));
        }
        String filePath = this.listDataFileCreator.create(dataList);
        Validate.notBlank(filePath, "filePath can't be blank!", new Object[0]);
        String attachFilePath = filePath;
        if (null != this.fileReworker) {
            String outputFile;
            attachFilePath = outputFile = this.fileReworker.rework(filePath);
        }
        this.sendEmail(attachFilePath, dataList);
        return null;
    }

    private void sendEmail(String attachFilePath, List<T> dataList) {
        MailSendRequest useMailSendRequest = BeanUtil.cloneBean(this.mailSendRequest);
        useMailSendRequest.setAttachFileLocations(attachFilePath);
        this.mailSender.send(useMailSendRequest);
    }

    public void setDataListQuery(DataListQuery<T> dataListQuery) {
        this.dataListQuery = dataListQuery;
    }

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setListDataFileCreator(ListDataFileCreator<T> listDataFileCreator) {
        this.listDataFileCreator = listDataFileCreator;
    }

    public void setFileReworker(FileReworker fileReworker) {
        this.fileReworker = fileReworker;
    }

    public void setMailSendRequest(MailSendRequest mailSendRequest) {
        this.mailSendRequest = mailSendRequest;
    }
}

