/*
 * Decompiled with CFR 0.152.
 */
package com.icebuf.util;

import android.annotation.SuppressLint;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@SuppressLint(value={"PrivateApi"})
public class SystemPropUtil {
    private static Class<?> sSystemPropClazz;
    private static Method sGetPropMethod;
    private static Method sSetPropMethod;

    public static String get(String key) {
        return SystemPropUtil.get(key, "");
    }

    public static String get(String key, String defaultValue) {
        String value = defaultValue;
        if (sSystemPropClazz != null && sGetPropMethod != null) {
            try {
                value = (String)sGetPropMethod.invoke(sSystemPropClazz, key, defaultValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static void set(String key, String value) {
        if (sSystemPropClazz != null && sSetPropMethod != null) {
            try {
                sSetPropMethod.invoke(sSystemPropClazz, key, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        try {
            sSystemPropClazz = Class.forName("android.os.SystemProperties");
            sGetPropMethod = sSystemPropClazz.getMethod("get", String.class, String.class);
            sSetPropMethod = sSystemPropClazz.getMethod("set", String.class, String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

