/*
 * Decompiled with CFR 0.152.
 */
package com.icebuf.util;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PackageUtil {
    private static final String TAG = PackageUtil.class.getSimpleName();
    public static final String ACTION_INSTALL_APK = "com.kty.sdk.action.INSTALL_APK";
    public static final String ACTION_INSTALL_COMMIT = "com.android.packageinstaller.ACTION_INSTALL_COMMIT";
    public static final int REQUEST_CODE_INSTALL = 1;
    public static final int REQUEST_CODE_UNINSTALL = 2;

    public static void install(Context context, String apkPath, Class<?> receiver) {
        PackageManager pm = context.getPackageManager();
        PackageInstaller packageInstaller = pm.getPackageInstaller();
        PackageInstaller.SessionParams params = new PackageInstaller.SessionParams(1);
        File apkFile = new File(apkPath);
        params.setSize(apkFile.length());
        int sessionId = -1;
        try {
            sessionId = packageInstaller.createSession(params);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"create session failed!");
            return;
        }
        PackageInstaller.Session session = PackageUtil.installApkFile(pm, sessionId, apkFile);
        if (session != null) {
            Intent broadcastIntent = new Intent(context, receiver);
            broadcastIntent.setAction(ACTION_INSTALL_APK);
            broadcastIntent.setFlags(0x10000000);
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)1, (Intent)broadcastIntent, (int)0x8000000);
            session.commit(pendingIntent.getIntentSender());
        } else {
            packageInstaller.abandonSession(sessionId);
        }
    }

    private static PackageInstaller.Session installApkFile(PackageManager pm, int sessionId, File file) {
        PackageInstaller.Session session;
        try {
            session = pm.getPackageInstaller().openSession(sessionId);
        }
        catch (IOException e) {
            return null;
        }
        session.setStagingProgress(0.0f);
        try {
            try (FileInputStream in = new FileInputStream(file);){
                long sizeBytes = file.length();
                try (OutputStream out = session.openWrite("Installer", 0L, sizeBytes);){
                    byte[] buffer = new byte[524288];
                    while (true) {
                        int numRead;
                        if ((numRead = ((InputStream)in).read(buffer)) == -1) {
                            session.fsync(out);
                            break;
                        }
                        out.write(buffer, 0, numRead);
                    }
                }
            }
            return session;
        }
        catch (IOException | SecurityException e) {
            Log.e((String)TAG, (String)"Could not write package", (Throwable)e);
            session.close();
            return null;
        }
    }

    public void uninstall(Context context, String packageName, Class<?> receiver) {
        this.uninstall(context, packageName, 2, receiver);
    }

    public void uninstall(Context context, String packageName, int requestCode, Class<?> receiver) {
        Intent intent = new Intent(context, receiver);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)0x8000000);
        PackageInstaller pi = context.getPackageManager().getPackageInstaller();
        pi.uninstall(packageName, pendingIntent.getIntentSender());
    }

    public static int getAppUid(Context context) {
        return PackageUtil.getAppUid(context, context.getPackageName());
    }

    public static int getAppUid(Context context, String pkgName) {
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = pm.getApplicationInfo(pkgName, 0);
            return applicationInfo.uid;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

