/*
 * Decompiled with CFR 0.152.
 */
package me.ibrahimsn.lib;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import androidx.annotation.XmlRes;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ibrahimsn.lib.BottomBarItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/ibrahimsn/lib/BottomBarParser;", "", "context", "Landroid/content/Context;", "res", "", "<init>", "(Landroid/content/Context;I)V", "parser", "Landroid/content/res/XmlResourceParser;", "parse", "", "Lme/ibrahimsn/lib/BottomBarItem;", "getTabConfig", "Companion", "lib_release"})
public final class BottomBarParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final XmlResourceParser parser;
    @NotNull
    private static final String ITEM_TAG = "item";
    @NotNull
    private static final String ICON_ATTRIBUTE = "icon";
    @NotNull
    private static final String TITLE_ATTRIBUTE = "title";
    @NotNull
    private static final String CONTENT_DESCRIPTION_ATTRIBUTE = "contentDescription";

    public BottomBarParser(@NotNull Context context, @XmlRes int res) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        XmlResourceParser xmlResourceParser = this.context.getResources().getXml(res);
        Intrinsics.checkNotNullExpressionValue((Object)xmlResourceParser, (String)"getXml(...)");
        this.parser = xmlResourceParser;
    }

    @NotNull
    public final List<BottomBarItem> parse() {
        int n;
        List items = new ArrayList();
        Integer eventType = null;
        do {
            eventType = this.parser.next();
            n = 2;
            if (eventType == n && Intrinsics.areEqual((Object)this.parser.getName(), (Object)ITEM_TAG)) {
                items.add(this.getTabConfig(this.parser));
            }
            n = 1;
        } while (eventType != n);
        return items;
    }

    private final BottomBarItem getTabConfig(XmlResourceParser parser) {
        int attributeCount = parser.getAttributeCount();
        String itemText = null;
        Drawable itemDrawable = null;
        String contentDescription = null;
        block14: for (int index = 0; index < attributeCount; ++index) {
            String string = parser.getAttributeName(index);
            if (string == null) continue;
            int n = -1;
            switch (string.hashCode()) {
                case -1273585213: {
                    if (string.equals(CONTENT_DESCRIPTION_ATTRIBUTE)) {
                        n = 1;
                    }
                    break;
                }
                case 3226745: {
                    if (string.equals(ICON_ATTRIBUTE)) {
                        n = 2;
                    }
                    break;
                }
                case 110371416: {
                    if (string.equals(TITLE_ATTRIBUTE)) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    itemDrawable = ContextCompat.getDrawable((Context)this.context, (int)parser.getAttributeResourceValue(index, 0));
                    continue block14;
                }
                case 3: {
                    String string2;
                    try {
                        string2 = this.context.getString(parser.getAttributeResourceValue(index, 0));
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        string2 = parser.getAttributeValue(index);
                    }
                    itemText = string2;
                    continue block14;
                }
                case 1: {
                    String string2;
                    try {
                        string2 = this.context.getString(parser.getAttributeResourceValue(index, 0));
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        string2 = parser.getAttributeValue(index);
                    }
                    contentDescription = string2;
                }
            }
        }
        if (itemDrawable == null) {
            throw new Throwable("Item icon can not be null!");
        }
        String string = String.valueOf(itemText);
        String string3 = contentDescription;
        if (string3 == null) {
            string3 = String.valueOf(itemText);
        }
        return new BottomBarItem(string, string3, itemDrawable, null, 0, 8, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lme/ibrahimsn/lib/BottomBarParser$Companion;", "", "<init>", "()V", "ITEM_TAG", "", "ICON_ATTRIBUTE", "TITLE_ATTRIBUTE", "CONTENT_DESCRIPTION_ATTRIBUTE", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

