/*
 * Decompiled with CFR 0.152.
 */
package com.bosong.frescozoomablelib.zoomable;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import com.bosong.frescozoomablelib.gestures.TransformGestureDetector;
import com.bosong.frescozoomablelib.zoomable.DefaultZoomableController;
import com.facebook.common.logging.FLog;

public abstract class AbstractAnimatedZoomableController
extends DefaultZoomableController {
    private boolean mIsAnimating;
    private final float[] mStartValues = new float[9];
    private final float[] mStopValues = new float[9];
    private final float[] mCurrentValues = new float[9];
    private final Matrix mNewTransform = new Matrix();
    private final Matrix mWorkingTransform = new Matrix();

    public AbstractAnimatedZoomableController(TransformGestureDetector transformGestureDetector) {
        super(transformGestureDetector);
    }

    @Override
    public void reset() {
        FLog.v(this.getLogTag(), (String)"reset");
        this.stopAnimation();
        this.mWorkingTransform.reset();
        this.mNewTransform.reset();
        super.reset();
    }

    @Override
    public boolean isIdentity() {
        return !this.isAnimating() && super.isIdentity();
    }

    @Override
    public void zoomToPoint(float scale, PointF imagePoint, PointF viewPoint) {
        this.zoomToPoint(scale, imagePoint, viewPoint, 7, 0L, null);
    }

    public void zoomToPoint(float scale, PointF imagePoint, PointF viewPoint, int limitFlags, long durationMs, @Nullable Runnable onAnimationComplete) {
        FLog.v(this.getLogTag(), (String)"zoomToPoint: duration %d ms", (Object)durationMs);
        this.calculateZoomToPointTransform(this.mNewTransform, scale, imagePoint, viewPoint, limitFlags);
        this.setTransform(this.mNewTransform, durationMs, onAnimationComplete);
    }

    public void setTransform(Matrix newTransform, long durationMs, @Nullable Runnable onAnimationComplete) {
        FLog.v(this.getLogTag(), (String)"setTransform: duration %d ms", (Object)durationMs);
        if (durationMs <= 0L) {
            this.setTransformImmediate(newTransform);
        } else {
            this.setTransformAnimated(newTransform, durationMs, onAnimationComplete);
        }
    }

    private void setTransformImmediate(Matrix newTransform) {
        FLog.v(this.getLogTag(), (String)"setTransformImmediate");
        this.stopAnimation();
        this.mWorkingTransform.set(newTransform);
        super.setTransform(newTransform);
        this.getDetector().restartGesture();
    }

    protected boolean isAnimating() {
        return this.mIsAnimating;
    }

    protected void setAnimating(boolean isAnimating) {
        this.mIsAnimating = isAnimating;
    }

    protected float[] getStartValues() {
        return this.mStartValues;
    }

    protected float[] getStopValues() {
        return this.mStopValues;
    }

    protected Matrix getWorkingTransform() {
        return this.mWorkingTransform;
    }

    @Override
    public void onGestureBegin(TransformGestureDetector detector) {
        FLog.v(this.getLogTag(), (String)"onGestureBegin");
        this.stopAnimation();
        super.onGestureBegin(detector);
    }

    @Override
    public void onGestureUpdate(TransformGestureDetector detector) {
        FLog.v(this.getLogTag(), (String)"onGestureUpdate %s", (Object)(this.isAnimating() ? "(ignored)" : ""));
        if (this.isAnimating()) {
            return;
        }
        super.onGestureUpdate(detector);
    }

    @Override
    public void onGestureEnd(TransformGestureDetector detector) {
        if (this.getScaleFactor() < 1.0f) {
            this.zoomToPoint(1.0f, new PointF(0.0f, 0.0f), new PointF(0.0f, 0.0f), 7, 300L, null);
        }
    }

    protected void calculateInterpolation(Matrix outMatrix, float fraction) {
        for (int i = 0; i < 9; ++i) {
            this.mCurrentValues[i] = (1.0f - fraction) * this.mStartValues[i] + fraction * this.mStopValues[i];
        }
        outMatrix.setValues(this.mCurrentValues);
    }

    public abstract void setTransformAnimated(Matrix var1, long var2, @Nullable Runnable var4);

    protected abstract void stopAnimation();

    protected abstract Class<?> getLogTag();
}

