/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.encryption;

import com.ironz.binaryprefs.encryption.KeyEncryption;
import com.ironz.binaryprefs.encryption.SafeEncoder;
import com.ironz.binaryprefs.exception.EncryptionException;
import java.util.Arrays;

public final class XorKeyEncryptionImpl
implements KeyEncryption {
    private static final String SMALL_XOR_MESSAGE = "XOR must be at least 16 bytes";
    private static final String MIRRORED_XOR_MESSAGE = "XOR must not be mirrored";
    private static final int KEY_LENGTH = 16;
    private final byte[] xor;
    private final SafeEncoder safeEncoder;

    public XorKeyEncryptionImpl(byte[] xor) {
        this.xor = xor;
        this.safeEncoder = new SafeEncoder();
        this.checkLength();
        this.checkMirror();
    }

    private void checkLength() {
        if (this.xor.length < 16) {
            throw new EncryptionException(SMALL_XOR_MESSAGE);
        }
    }

    private void checkMirror() {
        if (!this.isEven()) {
            return;
        }
        int halfSize = this.xor.length / 2;
        byte[] firstHalf = Arrays.copyOfRange(this.xor, 0, halfSize);
        byte[] secondHalf = Arrays.copyOfRange(this.xor, halfSize, this.xor.length);
        Arrays.sort(firstHalf);
        Arrays.sort(secondHalf);
        if (Arrays.equals(firstHalf, secondHalf)) {
            throw new EncryptionException(MIRRORED_XOR_MESSAGE);
        }
    }

    private boolean isEven() {
        return this.xor.length % 2 == 0;
    }

    @Override
    public String encrypt(String name) {
        byte[] original = name.getBytes();
        byte[] bytes = this.xorName(original);
        return this.safeEncoder.encodeToString(bytes);
    }

    @Override
    public String decrypt(String name) {
        byte[] decode = this.safeEncoder.decode(name);
        byte[] bytes = this.xorName(decode);
        return new String(bytes);
    }

    private byte[] xorName(byte[] original) {
        int length = original.length;
        byte[] result = new byte[length];
        for (int index = 0; index < length; ++index) {
            byte b = original[index];
            result[index] = this.xorByte(b);
        }
        return result;
    }

    private byte xorByte(byte raw) {
        byte temp = raw;
        for (byte b : this.xor) {
            temp = (byte)(temp ^ b);
        }
        return temp;
    }
}

