/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.file.transaction;

public final class TransactionElement {
    private static final byte[] EMPTY_CONTENT = new byte[0];
    public static final int ACTION_UPDATE = 1;
    public static final int ACTION_REMOVE = 2;
    private static final int ACTION_FETCH = 3;
    private final int action;
    private final String name;
    private final byte[] content;

    static TransactionElement createFetchElement(String name, byte[] content) {
        return new TransactionElement(3, name, content);
    }

    public static TransactionElement createUpdateElement(String name, byte[] content) {
        return new TransactionElement(1, name, content);
    }

    public static TransactionElement createRemovalElement(String name) {
        return new TransactionElement(2, name, EMPTY_CONTENT);
    }

    private TransactionElement(int action, String name, byte[] content) {
        this.action = action;
        this.name = name;
        this.content = content;
    }

    public int getAction() {
        return this.action;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getContent() {
        return this.content;
    }
}

