/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.serialization.serializer.persistable.io;

import com.ironz.binaryprefs.serialization.serializer.BooleanSerializer;
import com.ironz.binaryprefs.serialization.serializer.ByteSerializer;
import com.ironz.binaryprefs.serialization.serializer.CharSerializer;
import com.ironz.binaryprefs.serialization.serializer.DoubleSerializer;
import com.ironz.binaryprefs.serialization.serializer.FloatSerializer;
import com.ironz.binaryprefs.serialization.serializer.IntegerSerializer;
import com.ironz.binaryprefs.serialization.serializer.LongSerializer;
import com.ironz.binaryprefs.serialization.serializer.ShortSerializer;
import com.ironz.binaryprefs.serialization.serializer.StringSerializer;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.serializer.persistable.io.DataInput;

public final class PersistableObjectInputImpl
implements DataInput {
    private static final String BASE_INCORRECT_TYPE_MESSAGE = "cannot be deserialized in '%s' flag type";
    private static final String BASE_NOT_MIRRORED_MESSAGE = "May be your read/write contract isn't mirror-implemented?";
    private static final String INCORRECT_BOOLEAN_MESSAGE = "boolean cannot be deserialized in '%s' flag type";
    private static final String INCORRECT_BYTE_MESSAGE = "byte cannot be deserialized in '%s' flag type";
    private static final String INCORRECT_SHORT_MESSAGE = "short cannot be deserialized in '%s' flag type";
    private static final String INCORRECT_CHAR_MESSAGE = "char cannot be deserialized in '%s' flag type";
    private static final String INCORRECT_INT_MESSAGE = "int cannot be deserialized in '%s' flag type";
    private static final String INCORRECT_LONG_MESSAGE = "long cannot be deserialized in '%s' flag type";
    private static final String INCORRECT_FLOAT_MESSAGE = "float cannot be deserialized in '%s' flag type";
    private static final String INCORRECT_DOUBLE_MESSAGE = "double cannot be deserialized in '%s' flag type";
    private static final String INCORRECT_STRING_MESSAGE = "String cannot be deserialized in '%s' flag type";
    private static final String OUT_OF_BOUNDS_MESSAGE = "Can't read out of bounds array (%s bytes > %s bytes). May be your read/write contract isn't mirror-implemented?";
    private static final String EMPTY_BYTE_ARRAY_MESSAGE = "Cannot deserialize empty byte array! May be your read/write contract isn't mirror-implemented?";
    private static final String NULL_OBJECT_MESSAGE = "Can't serialize null object";
    private final BooleanSerializer booleanSerializer;
    private final ByteSerializer byteSerializer;
    private final CharSerializer charSerializer;
    private final DoubleSerializer doubleSerializer;
    private final FloatSerializer floatSerializer;
    private final IntegerSerializer integerSerializer;
    private final LongSerializer longSerializer;
    private final ShortSerializer shortSerializer;
    private final StringSerializer stringSerializer;
    private int offset = 0;
    private byte[] buffer;

    public PersistableObjectInputImpl(BooleanSerializer booleanSerializer, ByteSerializer byteSerializer, CharSerializer charSerializer, DoubleSerializer doubleSerializer, FloatSerializer floatSerializer, IntegerSerializer integerSerializer, LongSerializer longSerializer, ShortSerializer shortSerializer, StringSerializer stringSerializer) {
        this.booleanSerializer = booleanSerializer;
        this.byteSerializer = byteSerializer;
        this.charSerializer = charSerializer;
        this.doubleSerializer = doubleSerializer;
        this.floatSerializer = floatSerializer;
        this.integerSerializer = integerSerializer;
        this.longSerializer = longSerializer;
        this.shortSerializer = shortSerializer;
        this.stringSerializer = stringSerializer;
    }

    @Override
    public <T extends Persistable> T deserialize(byte[] bytes, Class<T> clazz) {
        this.buffer = bytes;
        this.checkBytes();
        this.checkNull(clazz);
        ++this.offset;
        int versionStub = this.readInt();
        T instance = this.newInstance(clazz);
        instance.readExternal(this);
        return instance;
    }

    private <T extends Persistable> T newInstance(Class<T> clazz) {
        try {
            return (T)((Persistable)clazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        int length = this.booleanSerializer.bytesLength();
        this.checkBounds(length);
        byte flag = this.buffer[this.offset];
        if (!this.booleanSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format(INCORRECT_BOOLEAN_MESSAGE, flag));
        }
        boolean b = this.booleanSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return b;
    }

    @Override
    public byte readByte() {
        int length = this.byteSerializer.bytesLength();
        this.checkBounds(length);
        byte flag = this.buffer[this.offset];
        if (!this.byteSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format(INCORRECT_BYTE_MESSAGE, flag));
        }
        byte b = this.byteSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return b;
    }

    @Override
    public short readShort() {
        int length = this.shortSerializer.bytesLength();
        this.checkBounds(length);
        byte flag = this.buffer[this.offset];
        if (!this.shortSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format(INCORRECT_SHORT_MESSAGE, flag));
        }
        short s = this.shortSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return s;
    }

    @Override
    public char readChar() {
        int length = this.charSerializer.bytesLength();
        this.checkBounds(length);
        byte flag = this.buffer[this.offset];
        if (!this.charSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format(INCORRECT_CHAR_MESSAGE, flag));
        }
        char c = this.charSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return c;
    }

    @Override
    public int readInt() {
        int length = this.integerSerializer.bytesLength();
        this.checkBounds(length);
        byte flag = this.buffer[this.offset];
        if (!this.integerSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format(INCORRECT_INT_MESSAGE, flag));
        }
        int i = this.integerSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return i;
    }

    @Override
    public long readLong() {
        int length = this.longSerializer.bytesLength();
        this.checkBounds(length);
        byte flag = this.buffer[this.offset];
        if (!this.longSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format(INCORRECT_LONG_MESSAGE, flag));
        }
        long l = this.longSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return l;
    }

    @Override
    public float readFloat() {
        int length = this.floatSerializer.bytesLength();
        this.checkBounds(length);
        byte flag = this.buffer[this.offset];
        if (!this.floatSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format(INCORRECT_FLOAT_MESSAGE, flag));
        }
        float f = this.floatSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return f;
    }

    @Override
    public double readDouble() {
        int length = this.doubleSerializer.bytesLength();
        this.checkBounds(length);
        byte flag = this.buffer[this.offset];
        if (!this.doubleSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format(INCORRECT_DOUBLE_MESSAGE, flag));
        }
        double d = this.doubleSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return d;
    }

    @Override
    public String readString() {
        int bytesStringSize = this.readInt();
        if (bytesStringSize == -1) {
            return null;
        }
        int length = this.stringSerializer.bytesLength() + bytesStringSize;
        this.checkBounds(length);
        byte flag = this.buffer[this.offset];
        if (!this.stringSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format(INCORRECT_STRING_MESSAGE, flag));
        }
        String s = this.stringSerializer.deserialize(this.buffer, this.offset, bytesStringSize);
        this.offset += length;
        return s;
    }

    private void checkBounds(int requiredLength) {
        int requiredBound = this.offset + requiredLength;
        int length = this.buffer.length;
        if (requiredBound > length) {
            throw new ArrayIndexOutOfBoundsException(String.format(OUT_OF_BOUNDS_MESSAGE, requiredBound, length));
        }
    }

    private void checkBytes() {
        if (this.buffer.length < 1) {
            throw new UnsupportedOperationException(EMPTY_BYTE_ARRAY_MESSAGE);
        }
    }

    private void checkNull(Object value) {
        if (value == null) {
            throw new NullPointerException(NULL_OBJECT_MESSAGE);
        }
    }
}

