/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.serialization.serializer;

public final class FloatSerializer {
    private static final byte FLAG = -6;
    private static final int SIZE = 5;

    public byte[] serialize(float value) {
        int val = Float.floatToIntBits(value);
        return new byte[]{-6, (byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
    }

    public float deserialize(byte[] bytes) {
        return this.deserialize(bytes, 0);
    }

    public float deserialize(byte[] bytes, int offset) {
        int i = 255;
        int value = (bytes[4 + offset] & i) + ((bytes[3 + offset] & i) << 8) + ((bytes[2 + offset] & i) << 16) + (bytes[1 + offset] << 24);
        return Float.intBitsToFloat(value);
    }

    public boolean isMatches(byte flag) {
        return flag == -6;
    }

    public int bytesLength() {
        return 5;
    }
}

