/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.encryption;

import com.ironz.binaryprefs.encryption.ByteEncryption;
import com.ironz.binaryprefs.exception.EncryptionException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesByteEncryptionImpl
implements ByteEncryption {
    private static final String AES = "AES";
    private static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5PADDING";
    private static final int KEY_LENGTH = 16;
    private final byte[] secretKeyBytes;
    private final byte[] initialVector;

    public AesByteEncryptionImpl(byte[] secretKeyBytes, byte[] initialVector) {
        this.secretKeyBytes = secretKeyBytes;
        this.initialVector = initialVector;
        this.checkLength();
    }

    private void checkLength() {
        if (this.secretKeyBytes.length != 16 || this.initialVector.length != 16) {
            throw new EncryptionException("Secret and initial vector must be 16 bytes");
        }
    }

    @Override
    public byte[] encrypt(byte[] bytes) {
        return this.encryptInternal(bytes);
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        return this.decryptInternal(bytes);
    }

    private byte[] encryptInternal(byte[] bytes) {
        try {
            Cipher encryptCipher = this.createEncryptCipher();
            return encryptCipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    private byte[] decryptInternal(byte[] bytes) {
        try {
            Cipher decryptCipher = this.createDecryptCipher();
            return decryptCipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    private Cipher createEncryptCipher() throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.secretKeyBytes, AES);
        IvParameterSpec iv = new IvParameterSpec(this.initialVector);
        Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
        cipher.init(1, (Key)secretKeySpec, iv);
        return cipher;
    }

    private Cipher createDecryptCipher() throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.secretKeyBytes, AES);
        IvParameterSpec iv = new IvParameterSpec(this.initialVector);
        Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
        cipher.init(2, (Key)secretKeySpec, iv);
        return cipher;
    }
}

