/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import android.content.Context;
import android.os.Looper;
import com.ironz.binaryprefs.BinaryPreferences;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.cache.ConcurrentCacheProviderImpl;
import com.ironz.binaryprefs.encryption.KeyEncryption;
import com.ironz.binaryprefs.encryption.ValueEncryption;
import com.ironz.binaryprefs.events.BroadcastEventBridgeImpl;
import com.ironz.binaryprefs.events.EventBridge;
import com.ironz.binaryprefs.events.MainThreadEventBridgeImpl;
import com.ironz.binaryprefs.exception.ExceptionHandler;
import com.ironz.binaryprefs.exception.PreferencesInitializationException;
import com.ironz.binaryprefs.file.adapter.NioFileAdapter;
import com.ironz.binaryprefs.file.directory.AndroidDirectoryProviderImpl;
import com.ironz.binaryprefs.file.transaction.MultiProcessTransactionImpl;
import com.ironz.binaryprefs.lock.SimpleLockFactoryImpl;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.serializer.persistable.PersistableRegistry;
import com.ironz.binaryprefs.task.ScheduledBackgroundTaskExecutor;
import java.io.File;

public final class BinaryPreferencesBuilder {
    private static final String INCORRECT_THREAD_INIT_MESSAGE = "Preferences should be instantiated in the main thread.";
    public static final String DEFAULT_NAME = "default";
    private final Context context;
    private final PersistableRegistry persistableRegistry = new PersistableRegistry();
    private File baseDir;
    private String name = "default";
    private boolean supportInterProcess = false;
    private KeyEncryption keyEncryption = KeyEncryption.NO_OP;
    private ValueEncryption valueEncryption = ValueEncryption.NO_OP;
    private ExceptionHandler exceptionHandler = ExceptionHandler.PRINT;

    public BinaryPreferencesBuilder(Context context) {
        this.context = context;
        this.baseDir = context.getFilesDir();
    }

    public BinaryPreferencesBuilder name(String name) {
        this.name = name;
        return this;
    }

    public BinaryPreferencesBuilder externalStorage(boolean value) {
        this.baseDir = value ? this.context.getExternalFilesDir(null) : this.context.getFilesDir();
        return this;
    }

    public BinaryPreferencesBuilder customDirectory(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public BinaryPreferencesBuilder supportInterProcess(boolean value) {
        this.supportInterProcess = value;
        return this;
    }

    public BinaryPreferencesBuilder keyEncryption(KeyEncryption keyEncryption) {
        this.keyEncryption = keyEncryption;
        return this;
    }

    public BinaryPreferencesBuilder valueEncryption(ValueEncryption valueEncryption) {
        this.valueEncryption = valueEncryption;
        return this;
    }

    public BinaryPreferencesBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public BinaryPreferencesBuilder registerPersistable(String key, Class<? extends Persistable> persistable) {
        this.persistableRegistry.register(key, persistable);
        return this;
    }

    public Preferences build() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new PreferencesInitializationException(INCORRECT_THREAD_INIT_MESSAGE);
        }
        AndroidDirectoryProviderImpl directoryProvider = new AndroidDirectoryProviderImpl(this.name, this.baseDir);
        NioFileAdapter fileAdapter = new NioFileAdapter(directoryProvider);
        SimpleLockFactoryImpl lockFactory = new SimpleLockFactoryImpl(this.name, directoryProvider);
        MultiProcessTransactionImpl fileTransaction = new MultiProcessTransactionImpl(fileAdapter, lockFactory, this.valueEncryption, this.keyEncryption);
        ConcurrentCacheProviderImpl cacheProvider = new ConcurrentCacheProviderImpl(this.name);
        ScheduledBackgroundTaskExecutor executor = new ScheduledBackgroundTaskExecutor(this.name, this.exceptionHandler);
        SerializerFactory serializerFactory = new SerializerFactory(this.persistableRegistry);
        EventBridge eventsBridge = this.supportInterProcess ? new BroadcastEventBridgeImpl(this.context, this.name, cacheProvider, serializerFactory, executor, this.valueEncryption) : new MainThreadEventBridgeImpl(this.name);
        return new BinaryPreferences(fileTransaction, eventsBridge, cacheProvider, executor, serializerFactory, lockFactory);
    }
}

