/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.events;

import android.content.SharedPreferences;
import android.os.Handler;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.events.EventBridge;
import com.ironz.binaryprefs.events.OnSharedPreferenceChangeListenerWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MainThreadEventBridgeImpl
implements EventBridge {
    private static final Map<String, List<SharedPreferences.OnSharedPreferenceChangeListener>> allListeners = new ConcurrentHashMap<String, List<SharedPreferences.OnSharedPreferenceChangeListener>>();
    private final Handler handler = new Handler();
    private final List<SharedPreferences.OnSharedPreferenceChangeListener> listeners;

    public MainThreadEventBridgeImpl(String prefName) {
        this.listeners = this.initListeners(prefName);
    }

    private List<SharedPreferences.OnSharedPreferenceChangeListener> initListeners(String prefName) {
        if (allListeners.containsKey(prefName)) {
            return allListeners.get(prefName);
        }
        ArrayList<SharedPreferences.OnSharedPreferenceChangeListener> listeners = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
        allListeners.put(prefName, listeners);
        return listeners;
    }

    @Override
    public void registerOnSharedPreferenceChangeListener(OnSharedPreferenceChangeListenerWrapper listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterOnSharedPreferenceChangeListener(OnSharedPreferenceChangeListenerWrapper listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyListenersUpdate(Preferences preferences, String key, byte[] bytes) {
        this.notifyListeners(preferences, key);
    }

    @Override
    public void notifyListenersRemove(Preferences preferences, String key) {
        this.notifyListeners(preferences, key);
    }

    private void notifyListeners(final Preferences preferences, final String key) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (SharedPreferences.OnSharedPreferenceChangeListener listener : MainThreadEventBridgeImpl.this.listeners) {
                    listener.onSharedPreferenceChanged((SharedPreferences)preferences, key);
                }
            }
        });
    }
}

