/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.serialization.serializer;

import java.util.HashSet;
import java.util.Set;

public final class StringSetSerializer {
    private static final byte FLAG = -1;
    private static final int SIZE = 1;

    public byte[] serialize(Set<String> set) {
        byte[][] bytes = new byte[set.size()][];
        int i = 0;
        int totalArraySize = 1;
        for (String s : set) {
            byte[] stringBytes = s.getBytes();
            byte[] stringSizeBytes = this.intToBytes(stringBytes.length);
            byte[] merged = new byte[stringBytes.length + stringSizeBytes.length];
            System.arraycopy(stringSizeBytes, 0, merged, 0, stringSizeBytes.length);
            System.arraycopy(stringBytes, 0, merged, stringSizeBytes.length, stringBytes.length);
            bytes[i] = merged;
            totalArraySize += merged.length;
            ++i;
        }
        byte[] totalArray = new byte[totalArraySize];
        totalArray[0] = -1;
        int offset = 1;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, totalArray, offset, b.length);
            offset += b.length;
        }
        return totalArray;
    }

    private byte[] intToBytes(int value) {
        int i = 255;
        return new byte[]{(byte)(value >>> 24 & i), (byte)(value >>> 16 & i), (byte)(value >>> 8 & i), (byte)(value & i)};
    }

    public Set<String> deserialize(byte[] bytes) {
        byte flag = bytes[0];
        if (flag == -1) {
            int stringSize;
            int integerBytesSize;
            HashSet<String> set = new HashSet<String>();
            for (int i = 1; i < bytes.length; i += integerBytesSize + stringSize) {
                integerBytesSize = 4;
                byte[] stringSizeBytes = new byte[integerBytesSize];
                System.arraycopy(bytes, i, stringSizeBytes, 0, stringSizeBytes.length);
                stringSize = this.intFromBytes(stringSizeBytes);
                byte[] stringBytes = new byte[stringSize];
                for (int k = 0; k < stringBytes.length; ++k) {
                    int stringOffset = i + k + integerBytesSize;
                    stringBytes[k] = bytes[stringOffset];
                }
                set.add(new String(stringBytes));
            }
            return set;
        }
        throw new ClassCastException(String.format("Set<String> cannot be deserialized in '%s' flag type", flag));
    }

    private int intFromBytes(byte[] bytes) {
        int i = 255;
        return (bytes[3] & i) + ((bytes[2] & i) << 8) + ((bytes[1] & i) << 16) + (bytes[0] << 24);
    }

    public boolean isMatches(byte flag) {
        return flag == -1;
    }

    public int bytesLength() {
        return 1;
    }
}

