/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.file;

import com.ironz.binaryprefs.encryption.ByteEncryption;
import com.ironz.binaryprefs.exception.FileOperationException;
import com.ironz.binaryprefs.file.FileAdapter;
import com.ironz.binaryprefs.file.PersistenceHandler;
import com.ironz.binaryprefs.file.directory.DirectoryProvider;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;

public final class NioFileAdapter
implements FileAdapter {
    private static final String[] EMPTY_STRING_NAMES_ARRAY = new String[0];
    private static final String BACKUP_EXTENSION = ".bak";
    private static final String R_MODE = "r";
    private static final String RWD_MODE = "rwd";
    private final File srcDir;
    private final ByteEncryption encryption;
    private final PersistenceHandler persistenceHandler;

    public NioFileAdapter(DirectoryProvider directoryProvider) {
        this(directoryProvider.getBaseDirectory(), ByteEncryption.NO_OP, PersistenceHandler.NO_OP);
    }

    public NioFileAdapter(DirectoryProvider directoryProvider, ByteEncryption encryption) {
        this(directoryProvider.getBaseDirectory(), encryption, PersistenceHandler.NO_OP);
    }

    public NioFileAdapter(DirectoryProvider directoryProvider, ByteEncryption encryption, PersistenceHandler persistenceHandler) {
        this(directoryProvider.getBaseDirectory(), encryption, persistenceHandler);
    }

    private NioFileAdapter(File srcDir, ByteEncryption encryption, PersistenceHandler persistenceHandler) {
        this.srcDir = srcDir;
        this.encryption = encryption;
        this.persistenceHandler = persistenceHandler;
    }

    @Override
    public String[] names() {
        return this.namesInternal();
    }

    private String[] namesInternal() {
        String[] list = this.srcDir.list();
        if (list == null) {
            return EMPTY_STRING_NAMES_ARRAY;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String name : list) {
            if (name.contains(".")) continue;
            names.add(name);
        }
        return names.toArray(EMPTY_STRING_NAMES_ARRAY);
    }

    @Override
    public byte[] fetch(String name) {
        byte[] bytes = this.fetchBackupOrOriginal(name);
        return this.encryption.decrypt(bytes);
    }

    private byte[] fetchBackupOrOriginal(String name) {
        File backupFile = new File(this.srcDir, name + BACKUP_EXTENSION);
        File file = new File(this.srcDir, name);
        if (backupFile.exists()) {
            this.deleteOriginal(file);
            this.swap(backupFile, file);
        }
        return this.fetchInternal(file);
    }

    private void deleteOriginal(File file) {
        file.delete();
    }

    private byte[] fetchInternal(File file) {
        FileChannel channel = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, R_MODE);
            channel = randomAccessFile.getChannel();
            int size = (int)randomAccessFile.length();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            byte[] bytes = new byte[size];
            buffer.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            throw new FileOperationException(e);
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void save(String name, byte[] bytes) {
        this.backupAndSave(name, bytes);
    }

    private void backupAndSave(String name, byte[] bytes) {
        File file = new File(this.srcDir, name);
        File backupFile = new File(this.srcDir, file.getName() + BACKUP_EXTENSION);
        byte[] encrypt = this.encryption.encrypt(bytes);
        this.swap(file, backupFile);
        this.saveInternal(file, encrypt);
        this.deleteBackup(backupFile);
        this.persistenceHandler.onSuccess(name);
    }

    private void deleteBackup(File backupFile) {
        backupFile.delete();
    }

    private void swap(File from, File to) {
        from.renameTo(to);
    }

    private void saveInternal(File file, byte[] bytes) {
        AbstractInterruptibleChannel channel = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, RWD_MODE);
            randomAccessFile.setLength(0L);
            channel = randomAccessFile.getChannel();
            MappedByteBuffer byteBuffer = ((FileChannel)channel).map(FileChannel.MapMode.READ_WRITE, 0L, bytes.length);
            byteBuffer.put(bytes);
            ((FileChannel)channel).write(byteBuffer);
            byteBuffer.force();
        }
        catch (Exception e) {
            throw new FileOperationException(e);
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (channel != null) {
                    channel.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void remove(String name) {
        this.removeInternal(name);
    }

    private void removeInternal(String name) {
        try {
            File file = new File(this.srcDir, name);
            file.delete();
        }
        catch (Exception e) {
            throw new FileOperationException(e);
        }
    }

    @Override
    public boolean contains(String name) {
        File file = new File(this.srcDir, name);
        return file.exists();
    }

    File getSrcDir() {
        return this.srcDir;
    }
}

