/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.events;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Process;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.cache.CacheProvider;
import com.ironz.binaryprefs.events.EventBridge;
import com.ironz.binaryprefs.file.FileAdapter;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class BroadcastEventBridgeImpl
implements EventBridge {
    private static final String INTENT_PREFIX = "com.ironz.binaryprefs.";
    private static final String ACTION_PREFERENCE_UPDATED = "com.ironz.binaryprefs.ACTION_PREFERENCE_UPDATED";
    private static final String ACTION_PREFERENCE_REMOVED = "com.ironz.binaryprefs.ACTION_PREFERENCE_REMOVED";
    private static final String PREFERENCE_NAME = "preference_name";
    private static final String PREFERENCE_KEY = "preference_update_key";
    private static final String PREFERENCE_PROCESS_ID = "preference_process_id";
    private final List<SharedPreferences.OnSharedPreferenceChangeListener> listeners = new CopyOnWriteArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
    private final Handler handler = new Handler();
    private final Context context;
    private final String prefName;
    private final CacheProvider cacheProvider;
    private final FileAdapter fileAdapter;
    private final SerializerFactory serializerFactory;
    private final TaskExecutor taskExecutor;
    private Preferences preferences;

    public BroadcastEventBridgeImpl(Context context, String prefName, CacheProvider cacheProvider, FileAdapter fileAdapter, SerializerFactory serializerFactory, TaskExecutor taskExecutor) {
        this.context = context;
        this.prefName = prefName;
        this.cacheProvider = cacheProvider;
        this.fileAdapter = fileAdapter;
        this.serializerFactory = serializerFactory;
        this.taskExecutor = taskExecutor;
        this.context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                BroadcastEventBridgeImpl.this.notifyUpdate(intent);
            }
        }, new IntentFilter(ACTION_PREFERENCE_UPDATED));
        this.context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                BroadcastEventBridgeImpl.this.notifyRemove(intent);
            }
        }, new IntentFilter(ACTION_PREFERENCE_REMOVED));
    }

    private void notifyUpdate(Intent intent) {
        if (!this.prefName.equals(intent.getStringExtra(PREFERENCE_NAME))) {
            return;
        }
        if (Process.myPid() == intent.getIntExtra(PREFERENCE_PROCESS_ID, 0)) {
            return;
        }
        final String key = intent.getStringExtra(PREFERENCE_KEY);
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                byte[] bytes = BroadcastEventBridgeImpl.this.fileAdapter.fetch(key);
                Object o = BroadcastEventBridgeImpl.this.serializerFactory.deserialize(key, bytes);
                BroadcastEventBridgeImpl.this.update(key, o);
            }
        });
    }

    private void notifyRemove(Intent intent) {
        if (!this.prefName.equals(intent.getStringExtra(PREFERENCE_NAME))) {
            return;
        }
        if (Process.myPid() == intent.getIntExtra(PREFERENCE_PROCESS_ID, 0)) {
            return;
        }
        final String key = intent.getStringExtra(PREFERENCE_KEY);
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                BroadcastEventBridgeImpl.this.remove(key);
            }
        });
    }

    private void update(String key, Object value) {
        this.cacheProvider.put(key, value);
        this.notifyListeners(key);
    }

    private void remove(String key) {
        this.cacheProvider.remove(key);
        this.notifyListeners(key);
    }

    private void notifyListeners(final String key) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (SharedPreferences.OnSharedPreferenceChangeListener listener : BroadcastEventBridgeImpl.this.listeners) {
                    listener.onSharedPreferenceChanged((SharedPreferences)BroadcastEventBridgeImpl.this.preferences, key);
                }
            }
        });
    }

    public void definePreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyListenersUpdate(Preferences preferences, String key, Object value) {
        this.update(key, value);
        this.sendUpdateIntent(key);
    }

    @Override
    public void notifyListenersRemove(Preferences preferences, String key) {
        this.remove(key);
        this.sendRemoveIntent(key);
    }

    private void sendUpdateIntent(String key) {
        Intent intent = new Intent(ACTION_PREFERENCE_UPDATED);
        intent.putExtra(PREFERENCE_PROCESS_ID, Process.myPid());
        intent.putExtra(PREFERENCE_NAME, this.prefName);
        intent.putExtra(PREFERENCE_KEY, key);
        this.context.sendBroadcast(intent);
    }

    private void sendRemoveIntent(String key) {
        Intent intent = new Intent(ACTION_PREFERENCE_REMOVED);
        intent.putExtra(PREFERENCE_PROCESS_ID, Process.myPid());
        intent.putExtra(PREFERENCE_NAME, this.prefName);
        intent.putExtra(PREFERENCE_KEY, key);
        this.context.sendBroadcast(intent);
    }
}

