/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.events;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.events.PreferenceEventBridge;
import java.util.ArrayList;
import java.util.List;

public final class BroadcastPreferenceEventBridgeImpl
implements PreferenceEventBridge {
    private static final String ACTION_PREFERENCE_CHANGED = "com.ironz.binaryprefs.ACTION_PREFERENCE_CHANGED";
    private static final String PREFERENCE_CHANGED_KEY = "preference_changed_key";
    private final List<SharedPreferences.OnSharedPreferenceChangeListener> listeners = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
    private final IntentFilter filter = new IntentFilter("com.ironz.binaryprefs.ACTION_PREFERENCE_CHANGED");
    private final Context context;
    private final BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (!BroadcastPreferenceEventBridgeImpl.ACTION_PREFERENCE_CHANGED.equals(intent.getAction())) {
                return;
            }
            for (SharedPreferences.OnSharedPreferenceChangeListener listener : BroadcastPreferenceEventBridgeImpl.this.listeners) {
                listener.onSharedPreferenceChanged(null, intent.getStringExtra(BroadcastPreferenceEventBridgeImpl.PREFERENCE_CHANGED_KEY));
            }
        }
    };

    public BroadcastPreferenceEventBridgeImpl(Context context) {
        this.context = context;
    }

    @Override
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        if (this.listeners.isEmpty()) {
            this.context.registerReceiver(this.receiver, this.filter);
        }
        this.listeners.add(listener);
    }

    @Override
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.context.unregisterReceiver(this.receiver);
        }
    }

    @Override
    public void notifyListeners(Preferences preferences, String key) {
        Intent intent = new Intent(ACTION_PREFERENCE_CHANGED);
        intent.putExtra(PREFERENCE_CHANGED_KEY, key);
        this.context.sendBroadcast(intent);
    }
}

