/*
 * Decompiled with CFR 0.152.
 */
package com.iambedant.text;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v4.widget.AutoSizeableTextView;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.iambedant.text.ExtensionsKt;
import com.iambedant.text.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0012\u001a\u00020\u00132\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\rJ\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\rR\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/iambedant/text/OutlineTextView;", "Landroid/support/v7/widget/AppCompatTextView;", "Landroid/support/v4/widget/AutoSizeableTextView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defaultStrokeWidth", "", "isDrawing", "", "strokeColor", "strokeWidth", "initResources", "", "invalidate", "onDraw", "canvas", "Landroid/graphics/Canvas;", "setStrokeColor", "color", "setStrokeWidth", "width", "unit", "outline-textview_release"})
public final class OutlineTextView
extends AppCompatTextView
implements AutoSizeableTextView {
    private final float defaultStrokeWidth = 0.0f;
    private boolean isDrawing;
    private int strokeColor;
    private float strokeWidth;

    private final void initResources(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a;
            Context context2 = context;
            TypedArray typedArray = a = context2 != null ? context2.obtainStyledAttributes(attrs, R.styleable.outlineAttrs) : null;
            if (typedArray == null) {
                Intrinsics.throwNpe();
            }
            this.strokeColor = typedArray.getColor(R.styleable.outlineAttrs_outlineColor, this.getCurrentTextColor());
            this.strokeWidth = a.getFloat(R.styleable.outlineAttrs_outlineWidth, this.defaultStrokeWidth);
            a.recycle();
        } else {
            this.strokeColor = this.getCurrentTextColor();
            this.strokeWidth = this.defaultStrokeWidth;
        }
        this.setStrokeWidth(this.strokeWidth);
    }

    public final void setStrokeColor(int color) {
        this.strokeColor = color;
    }

    public final void setStrokeWidth(float width) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.strokeWidth = ExtensionsKt.toPx(width, context);
    }

    public final void setStrokeWidth(int unit, float width) {
        this.strokeWidth = TypedValue.applyDimension((int)unit, (float)width, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    public void invalidate() {
        if (this.isDrawing) {
            return;
        }
        super.invalidate();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.strokeWidth > 0.0f) {
            this.isDrawing = true;
            TextPaint p = this.getPaint();
            p.setStyle(Paint.Style.FILL);
            super.onDraw(canvas);
            int currentTextColor = this.getCurrentTextColor();
            p.setStyle(Paint.Style.STROKE);
            p.setStrokeWidth(this.strokeWidth);
            this.setTextColor(this.strokeColor);
            super.onDraw(canvas);
            this.setTextColor(currentTextColor);
            this.isDrawing = false;
        } else {
            super.onDraw(canvas);
        }
    }

    public OutlineTextView(@Nullable Context context) {
        super(context);
        this.initResources(context, null);
    }

    public OutlineTextView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initResources(context, attrs);
    }

    public OutlineTextView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initResources(context, attrs);
    }
}

