/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class TextRW {
    private static Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public static void setDefaultCharset(Charset defaultCharset) {
        if (defaultCharset == null) {
            throw new NullPointerException("Param defaultCharset can not be null.");
        }
        DEFAULT_CHARSET = defaultCharset;
    }

    public static String readAllText(InputStream inputStream, Charset charset) throws IOException {
        int readCount;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder stringBuilder = new StringBuilder();
        char[] buffer = new char[1024];
        while ((readCount = bufferedReader.read(buffer)) > -1) {
            stringBuilder.append(buffer, 0, readCount);
        }
        return stringBuilder.toString();
    }

    public static String readAllText(InputStream inputStream) throws IOException {
        return TextRW.readAllText(inputStream, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAllText(File file, Charset charset) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string = TextRW.readAllText(fileInputStream, charset);
            return string;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String readAllText(File file) throws IOException {
        return TextRW.readAllText(file, DEFAULT_CHARSET);
    }

    public static void writeAllText(OutputStream outputStream, Charset charset, String content) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset);
        outputStreamWriter.write(content);
        outputStreamWriter.flush();
    }

    public static void writeAllText(OutputStream outputStream, String content) throws IOException {
        TextRW.writeAllText(outputStream, DEFAULT_CHARSET, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllText(File file, Charset charset, String content) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            TextRW.writeAllText(fileOutputStream, charset, content);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeAllText(File file, String content) throws IOException {
        TextRW.writeAllText(file, DEFAULT_CHARSET, content);
    }

    public static List<String> readAllLines(InputStream inputStream, Charset charset) throws IOException {
        String tempString;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ArrayList<String> lines = new ArrayList<String>();
        while ((tempString = bufferedReader.readLine()) != null) {
            lines.add(tempString);
        }
        return lines;
    }

    public static List<String> readAllLines(InputStream inputStream) throws IOException {
        return TextRW.readAllLines(inputStream, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readAllLines(File file, Charset charset) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            List<String> list = TextRW.readAllLines(fileInputStream, charset);
            return list;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static List<String> readAllLines(File file) throws IOException {
        return TextRW.readAllLines(file, DEFAULT_CHARSET);
    }

    public static void writeAllLines(OutputStream outputStream, Charset charset, List<String> content) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset);
        for (String line : content) {
            outputStreamWriter.write(line);
            outputStreamWriter.write(10);
        }
        outputStreamWriter.flush();
    }

    public static void writeAllLines(OutputStream outputStream, List<String> content) throws IOException {
        TextRW.writeAllLines(outputStream, DEFAULT_CHARSET, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllLines(File file, Charset charset, List<String> content) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            TextRW.writeAllLines(fileOutputStream, charset, content);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeAllLines(File file, List<String> content) throws IOException {
        TextRW.writeAllLines(file, DEFAULT_CHARSET, content);
    }
}

