/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import site.iway.javahelpers.StringHelper;

public class Money
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long MAX_CENTS = 99999999999999L;
    public static final long DEF_CENTS = 0L;
    public static final long MIN_CENTS = -99999999999999L;
    public static final Money ZERO = new Money(0L);
    public static final Money MAX = new Money(99999999999999L);
    public static final Money MIN = new Money(-99999999999999L);
    private volatile long mCents;
    private static final NumberFormat sNormalFormatter = NumberFormat.getNumberInstance(Locale.CHINA);
    private static final NumberFormat sStandardFormatter;
    private static final NumberFormat sCurrencyFormatter;

    private void setFromLong(long cents) {
        if (cents > 99999999999999L) {
            throw new RuntimeException("value is too big !");
        }
        if (cents < -99999999999999L) {
            throw new RuntimeException("value is too small !");
        }
        this.mCents = cents;
    }

    private void setFromDouble(double value) {
        if (value < 0.0) {
            this.setFromLong((long)(value * 100.0 - 0.5));
        }
        if (value > 0.0) {
            this.setFromLong((long)(value * 100.0 + 0.5));
        }
    }

    public Money(long cents) {
        this.setFromLong(cents);
    }

    public Money(double value) {
        this.setFromDouble(value);
    }

    public Money(String value) {
        if (StringHelper.nullOrEmpty(value)) {
            value = "0.0";
        }
        this.setFromDouble(Double.parseDouble(value));
    }

    public Money() {
        this.mCents = 0L;
    }

    public long cents() {
        return this.mCents;
    }

    public Money plus(Money money) {
        return new Money(this.mCents + money.mCents);
    }

    public Money minus(Money money) {
        return new Money(this.mCents - money.mCents);
    }

    public Money multiply(Money money) {
        return new Money(this.mCents * money.mCents);
    }

    public Money divide(Money money) {
        return new Money(this.mCents / money.mCents);
    }

    public Money reverse() {
        return new Money(-this.mCents);
    }

    public boolean biggerThan(Money money) {
        return this.mCents > money.mCents;
    }

    public boolean smallerThan(Money money) {
        return this.mCents < money.mCents;
    }

    public boolean equals(Object o) {
        if (o instanceof Money) {
            return this.mCents == ((Money)o).mCents;
        }
        return false;
    }

    public boolean isZero() {
        return this.mCents == 0L;
    }

    public boolean isMax() {
        return this.mCents == 99999999999999L;
    }

    public boolean isMin() {
        return this.mCents == -99999999999999L;
    }

    public double toDoubleFormat() {
        double doubleFormat = this.mCents;
        return doubleFormat / 100.0;
    }

    public String toNormalFormat() {
        return sNormalFormatter.format(this.toDoubleFormat());
    }

    public String toStandardFormat() {
        return sStandardFormatter.format(this.mCents);
    }

    public String toCurrencyFormat() {
        return sCurrencyFormatter.format(this.toDoubleFormat());
    }

    private String getBooleanString(int qian, int bai, int shi, int ge) {
        char[] chars = new char[]{qian == 0 ? (char)'0' : '1', bai == 0 ? (char)'0' : '1', shi == 0 ? (char)'0' : '1', ge == 0 ? (char)'0' : '1'};
        return new String(chars);
    }

    private String getBooleanString(String yi, String wan, String yuan) {
        char[] chars = new char[3];
        int n = chars[0] = yi.equals("\u96f6") ? 48 : 49;
        int n2 = wan.equals("\u96f6") ? 48 : (chars[1] = wan.length() > 1 && wan.charAt(1) == '\u4edf' ? 50 : 49);
        chars[2] = yuan.equals("\u96f6") ? 48 : (wan.length() > 1 && wan.charAt(1) == '\u4edf' ? 50 : 49);
        return new String(chars);
    }

    private String getBooleanString(String number1, int jiao, int fen) {
        char[] chars = new char[]{number1.equals("\u96f6") ? (char)'0' : '1', jiao == 0 ? (char)'0' : '1', fen == 0 ? (char)'0' : '1'};
        return new String(chars);
    }

    private String getNumber(int qian, int bai, int shi, int ge) {
        String booleanString = this.getBooleanString(qian, bai, shi, ge);
        char[] digits = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
        if (booleanString.equals("0000")) {
            return "\u96f6";
        }
        if (booleanString.equals("0001")) {
            return digits[ge] + "";
        }
        if (booleanString.equals("0010")) {
            return digits[shi] + "\u62fe";
        }
        if (booleanString.equals("0011")) {
            return digits[shi] + "\u62fe" + digits[ge];
        }
        if (booleanString.equals("0100")) {
            return digits[bai] + "\u4f70";
        }
        if (booleanString.equals("0101")) {
            return digits[bai] + "\u4f70\u96f6" + digits[ge];
        }
        if (booleanString.equals("0110")) {
            return digits[bai] + "\u4f70" + digits[shi] + "\u62fe";
        }
        if (booleanString.equals("0111")) {
            return digits[bai] + "\u4f70" + digits[shi] + "\u62fe" + digits[ge];
        }
        if (booleanString.equals("1000")) {
            return digits[qian] + "\u4edf";
        }
        if (booleanString.equals("1001")) {
            return digits[qian] + "\u4edf\u96f6" + digits[ge];
        }
        if (booleanString.equals("1010")) {
            return digits[qian] + "\u4edf\u96f6" + digits[shi] + "\u62fe";
        }
        if (booleanString.equals("1011")) {
            return digits[qian] + "\u4edf\u96f6" + digits[shi] + "\u62fe" + digits[ge];
        }
        if (booleanString.equals("1100")) {
            return digits[qian] + "\u4edf" + digits[bai] + "\u4f70";
        }
        if (booleanString.equals("1101")) {
            return digits[qian] + "\u4edf" + digits[bai] + "\u4f70\u96f6" + digits[ge];
        }
        if (booleanString.equals("1110")) {
            return digits[qian] + "\u4edf" + digits[bai] + "\u4f70" + digits[shi] + "\u62fe";
        }
        if (booleanString.equals("1111")) {
            return digits[qian] + "\u4edf" + digits[bai] + "\u4f70" + digits[shi] + "\u62fe" + digits[ge];
        }
        return null;
    }

    private String getNumber1(String yi, String wan, String yuan) {
        String booleanString = this.getBooleanString(yi, wan, yuan);
        if (booleanString.equals("000")) {
            return yuan;
        }
        if (booleanString.equals("001")) {
            return yuan;
        }
        if (booleanString.equals("002")) {
            return yuan;
        }
        if (booleanString.equals("010")) {
            return wan + "\u4e07";
        }
        if (booleanString.equals("011")) {
            return wan + "\u4e07\u96f6" + yuan;
        }
        if (booleanString.equals("012")) {
            return wan + "\u4e07" + yuan;
        }
        if (booleanString.equals("020")) {
            return wan + "\u4e07";
        }
        if (booleanString.equals("021")) {
            return wan + "\u4e07\u96f6" + yuan;
        }
        if (booleanString.equals("022")) {
            return wan + "\u4e07" + yuan;
        }
        if (booleanString.equals("100")) {
            return yi + "\u4ebf";
        }
        if (booleanString.equals("101")) {
            return yi + "\u4ebf\u96f6" + yuan;
        }
        if (booleanString.equals("102")) {
            return yi + "\u4ebf\u96f6" + yuan;
        }
        if (booleanString.equals("110")) {
            return yi + "\u4ebf\u96f6" + wan + "\u4e07";
        }
        if (booleanString.equals("111")) {
            return yi + "\u4ebf\u96f6" + wan + "\u4e07\u96f6" + yuan;
        }
        if (booleanString.equals("112")) {
            return yi + "\u4ebf\u96f6" + wan + "\u4e07" + yuan;
        }
        if (booleanString.equals("120")) {
            return yi + "\u4ebf" + wan + "\u4e07";
        }
        if (booleanString.equals("121")) {
            return yi + "\u4ebf" + wan + "\u4e07\u96f6" + yuan;
        }
        if (booleanString.equals("122")) {
            return yi + "\u4ebf" + wan + "\u4e07" + yuan;
        }
        return null;
    }

    private String getNumber2(String number1, int jiao, int fen) {
        String booleanString = this.getBooleanString(number1, jiao, fen);
        char[] digits = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
        if (booleanString.equals("000")) {
            return number1 + "\u5143\u6574";
        }
        if (booleanString.equals("001")) {
            return digits[fen] + "\u5206";
        }
        if (booleanString.equals("010")) {
            return digits[jiao] + "\u89d2";
        }
        if (booleanString.equals("011")) {
            return digits[jiao] + "\u89d2" + digits[fen] + "\u5206";
        }
        if (booleanString.equals("100")) {
            return number1 + "\u5143\u6574";
        }
        if (booleanString.equals("101")) {
            return number1 + "\u5143\u96f6" + digits[fen] + "\u5206";
        }
        if (booleanString.equals("110")) {
            return number1 + "\u5143" + digits[jiao] + "\u89d2";
        }
        if (booleanString.equals("111")) {
            return number1 + "\u5143" + digits[jiao] + "\u89d2" + digits[fen] + "\u5206";
        }
        return null;
    }

    public String toChineseFormat() {
        long absCents = Math.abs(this.mCents);
        String standardFormat = sStandardFormatter.format(absCents);
        char[] array = standardFormat.toCharArray();
        String yi = this.getNumber(array[0] - 48, array[1] - 48, array[2] - 48, array[3] - 48);
        String wan = this.getNumber(array[4] - 48, array[5] - 48, array[6] - 48, array[7] - 48);
        String yuan = this.getNumber(array[8] - 48, array[9] - 48, array[10] - 48, array[11] - 48);
        String number1 = this.getNumber1(yi, wan, yuan);
        String number2 = this.getNumber2(number1, array[12] - 48, array[13] - 48);
        if (this.mCents < 0L) {
            return "\u8d1f" + number2;
        }
        return number2;
    }

    static {
        sNormalFormatter.setMinimumFractionDigits(2);
        sNormalFormatter.setMaximumFractionDigits(2);
        sNormalFormatter.setGroupingUsed(false);
        sStandardFormatter = NumberFormat.getNumberInstance(Locale.CHINA);
        sStandardFormatter.setMaximumIntegerDigits(14);
        sStandardFormatter.setMinimumIntegerDigits(14);
        sStandardFormatter.setParseIntegerOnly(true);
        sStandardFormatter.setGroupingUsed(false);
        sCurrencyFormatter = NumberFormat.getNumberInstance(Locale.CHINA);
        sCurrencyFormatter.setMinimumFractionDigits(2);
        sCurrencyFormatter.setMaximumFractionDigits(2);
        sCurrencyFormatter.setGroupingUsed(true);
    }
}

