/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.Expose;

public class GsonHelper {
    public static final int TYPE_ALL_FIELDS = 0;
    public static final int TYPE_ONLY_EXPOSE_BASED_FIELDS = 1;
    public static final int TYPE_NORMAL_AND_EXPOSE_BASED_FIELDS = 2;
    private static JsonElementTransformer<String> sStringJsonElementTransformer = new JsonElementTransformer<String>(){

        @Override
        public String transform(JsonElement jsonElement) {
            return jsonElement == null ? null : jsonElement.getAsString();
        }
    };

    public static Gson create(int fields) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        switch (fields) {
            case 0: {
                return gsonBuilder.create();
            }
            case 1: {
                gsonBuilder.excludeFieldsWithoutExposeAnnotation();
                return gsonBuilder.create();
            }
            case 2: {
                gsonBuilder.addSerializationExclusionStrategy(new ExclusionStrategy(){

                    public boolean shouldSkipField(FieldAttributes f) {
                        Expose expose = (Expose)f.getAnnotation(Expose.class);
                        return expose != null && !expose.serialize();
                    }

                    public boolean shouldSkipClass(Class<?> clazz) {
                        return false;
                    }
                });
                gsonBuilder.addDeserializationExclusionStrategy(new ExclusionStrategy(){

                    public boolean shouldSkipField(FieldAttributes f) {
                        Expose expose = (Expose)f.getAnnotation(Expose.class);
                        return expose != null && !expose.deserialize();
                    }

                    public boolean shouldSkipClass(Class<?> clazz) {
                        return false;
                    }
                });
                return gsonBuilder.create();
            }
        }
        throw new RuntimeException("Invalid param fields=" + fields);
    }

    public static JsonElement toElement(String json) {
        JsonParser jsonParser = new JsonParser();
        return jsonParser.parse(json);
    }

    public static JsonObject toObject(String json) {
        return GsonHelper.toElement(json).getAsJsonObject();
    }

    public static JsonElement toElement(Object object, int fields) {
        Gson gson = GsonHelper.create(fields);
        return gson.toJsonTree(object);
    }

    public static JsonObject toObject(Object object, int fields) {
        return GsonHelper.toElement(object, fields).getAsJsonObject();
    }

    public static JsonElement innerElement(JsonElement jsonElement, String ... names) {
        try {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (int i = 0; i < names.length - 1; ++i) {
                jsonObject = jsonObject.getAsJsonObject(names[i]);
            }
            return jsonObject.get(names[names.length - 1]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JsonObject innerObject(JsonElement jsonElement, String ... names) {
        JsonElement innerElement = GsonHelper.innerElement(jsonElement, names);
        return innerElement == null ? null : innerElement.getAsJsonObject();
    }

    public static JsonArray innerArray(JsonElement jsonElement, String ... names) {
        JsonElement innerElement = GsonHelper.innerElement(jsonElement, names);
        return innerElement == null ? null : innerElement.getAsJsonArray();
    }

    public static String innerString(JsonElement jsonElement, String ... names) {
        JsonElement innerElement = GsonHelper.innerElement(jsonElement, names);
        return sStringJsonElementTransformer.transform(innerElement);
    }

    public static String[] innerStrings(JsonElement jsonElement, String ... names) {
        String[] stringArray;
        JsonArray innerArray = GsonHelper.innerArray(jsonElement, names);
        if (innerArray == null) {
            stringArray = new String[]{};
        } else {
            stringArray = new String[innerArray.size()];
            GsonHelper.transformArray(innerArray, stringArray, sStringJsonElementTransformer);
        }
        return stringArray;
    }

    public static <T> void transformArray(JsonArray src, T[] dst, JsonElementTransformer<T> transformer) {
        int size = src.size();
        for (int i = 0; i < size; ++i) {
            dst[i] = transformer.transform(src.get(i));
        }
    }

    public static interface JsonElementTransformer<T> {
        public T transform(JsonElement var1);
    }
}

