/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

public class AutoExpandShortArray {
    private short[] mArray;
    private short[] mShort;
    private int mLength;

    public AutoExpandShortArray(int initSize) {
        this.mArray = new short[initSize];
        this.mShort = new short[1];
        this.mLength = 0;
    }

    public AutoExpandShortArray() {
        this(4096);
    }

    public void add(short[] data, int startIndex, int count) {
        int targetLength = this.mLength + count;
        if (targetLength >= this.mArray.length) {
            short[] newArray = new short[targetLength * 2];
            System.arraycopy(this.mArray, 0, newArray, 0, this.mLength);
            this.mArray = newArray;
        }
        System.arraycopy(data, startIndex, this.mArray, this.mLength, count);
        this.mLength += count;
    }

    public void add(short[] ss) {
        this.add(ss, 0, ss.length);
    }

    public void add(short s) {
        this.mShort[0] = s;
        this.add(this.mShort);
    }

    public short get(int index) {
        if (index > -1 && index < this.mLength) {
            return this.mArray[index];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void set(int index, short s) {
        if (index > -1 && index < this.mLength) {
            this.mArray[index] = s;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public boolean has(short s) {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mArray[i] != s) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.mLength = 0;
    }

    public int size() {
        return this.mLength;
    }

    public short[] getOutArray() {
        short[] array = new short[this.mLength];
        System.arraycopy(this.mArray, 0, array, 0, this.mLength);
        return array;
    }

    public short[] getRawArray() {
        return this.mArray;
    }
}

