/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyuwah.draggableviewlib;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import io.github.hyuwah.draggableviewlib.DraggableListener;
import io.github.hyuwah.draggableviewlib.DraggableUtils;
import io.github.hyuwah.draggableviewlib.DraggableView$WhenMappings;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002+,B)\b\u0002\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u000b\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u001d2\b\b\u0002\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'J\u0010\u0010)\u001a\u00020\u001d2\b\b\u0002\u0010#\u001a\u00020$J\u0006\u0010*\u001a\u00020\u001dR$\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006-"}, d2={"Lio/github/hyuwah/draggableviewlib/DraggableView;", "T", "Landroid/view/View;", "", "targetView", "sticky", "Lio/github/hyuwah/draggableviewlib/DraggableView$Mode;", "animated", "", "listener", "Lio/github/hyuwah/draggableviewlib/DraggableListener;", "(Landroid/view/View;Lio/github/hyuwah/draggableviewlib/DraggableView$Mode;ZLio/github/hyuwah/draggableviewlib/DraggableListener;)V", "value", "getAnimated", "()Z", "setAnimated", "(Z)V", "<set-?>", "isMinimized", "getListener", "()Lio/github/hyuwah/draggableviewlib/DraggableListener;", "setListener", "(Lio/github/hyuwah/draggableviewlib/DraggableListener;)V", "getSticky", "()Lio/github/hyuwah/draggableviewlib/DraggableView$Mode;", "setSticky", "(Lio/github/hyuwah/draggableviewlib/DraggableView$Mode;)V", "Landroid/view/View;", "disableDrag", "", "dockToEdge", "enableDrag", "getView", "()Landroid/view/View;", "hide", "durationMs", "", "setViewPosition", "x", "", "y", "show", "undock", "Builder", "Mode", "draggableviewlib_release"})
public final class DraggableView<T extends View> {
    private T targetView;
    @NotNull
    private Mode sticky;
    private boolean animated;
    @Nullable
    private DraggableListener listener;
    private boolean isMinimized;

    @NotNull
    public final Mode getSticky() {
        return this.sticky;
    }

    public final void setSticky(@NotNull Mode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.sticky = value;
        this.enableDrag();
    }

    public final boolean getAnimated() {
        return this.animated;
    }

    public final void setAnimated(boolean value) {
        this.animated = value;
        this.enableDrag();
    }

    @Nullable
    public final DraggableListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable DraggableListener value) {
        this.listener = value;
        this.enableDrag();
    }

    public final boolean isMinimized() {
        return this.isMinimized;
    }

    @NotNull
    public final T getView() {
        return this.targetView;
    }

    public final void setViewPosition(float x, float y) {
        this.targetView.setX(x);
        this.targetView.setY(y);
    }

    public final void disableDrag() {
        this.targetView.setOnTouchListener(null);
    }

    public final void enableDrag() {
        DraggableUtils.setupDraggable(this.targetView, this.sticky, this.animated, this.listener);
    }

    public final void show(int durationMs) {
        T t = this.targetView;
        boolean bl = false;
        boolean bl2 = false;
        T $this$with = t;
        boolean bl3 = false;
        if ($this$with.getVisibility() != 0) {
            $this$with.setVisibility(0);
            $this$with.animate().scaleY(1.0f).scaleX(1.0f).setDuration((long)durationMs).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener(null).start();
        }
    }

    public static /* synthetic */ void show$default(DraggableView draggableView, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 300;
        }
        draggableView.show(n);
    }

    public final void hide(int durationMs) {
        T t = this.targetView;
        boolean bl = false;
        boolean bl2 = false;
        T $this$with = t;
        boolean bl3 = false;
        if ($this$with.getVisibility() != 8) {
            Animation animation = $this$with.getAnimation();
            if (animation == null || animation.hasEnded()) {
                $this$with.animate().scaleY(0.0f).scaleX(0.0f).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration((long)durationMs).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter($this$with){
                    final /* synthetic */ View $this_with;

                    public void onAnimationEnd(@Nullable Animator animation) {
                        super.onAnimationEnd(animation);
                        this.$this_with.setVisibility(8);
                    }
                    {
                        this.$this_with = $receiver;
                    }
                }).start();
            }
        }
    }

    public static /* synthetic */ void hide$default(DraggableView draggableView, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 300;
        }
        draggableView.hide(n);
    }

    public final void undock() {
        if (!this.isMinimized) {
            return;
        }
        T t = this.targetView;
        boolean bl = false;
        boolean bl2 = false;
        T $this$with = t;
        boolean bl3 = false;
        ViewParent viewParent = $this$with.getParent();
        if (viewParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.View");
        }
        float parentWidth = ((View)viewParent).getWidth();
        switch (DraggableView$WhenMappings.$EnumSwitchMapping$0[this.sticky.ordinal()]) {
            case 1: {
                if ($this$with.getX() < DraggableUtils.marginStart($this$with)) {
                    $this$with.animate().translationX(0.0f).start();
                } else if ($this$with.getX() > parentWidth - (float)$this$with.getWidth() - DraggableUtils.marginEnd($this$with)) {
                    $this$with.animate().translationXBy(-((float)$this$with.getWidth() / 2.0f) - DraggableUtils.marginEnd($this$with)).start();
                }
                this.enableDrag();
                this.isMinimized = false;
                break;
            }
            case 2: {
                break;
            }
            default: {
                return;
            }
        }
    }

    public final void dockToEdge() {
        if (this.isMinimized) {
            return;
        }
        T t = this.targetView;
        boolean bl = false;
        boolean bl2 = false;
        T $this$with = t;
        boolean bl3 = false;
        ViewParent viewParent = $this$with.getParent();
        if (viewParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.View");
        }
        float parentWidth = ((View)viewParent).getWidth();
        switch (DraggableView$WhenMappings.$EnumSwitchMapping$1[this.sticky.ordinal()]) {
            case 1: {
                float f = $this$with.getX();
                if (f == DraggableUtils.marginStart($this$with)) {
                    float targetDockedX = -((float)$this$with.getWidth() / (float)2 + DraggableUtils.marginStart($this$with));
                    $this$with.animate().translationXBy(targetDockedX).start();
                } else if (f == parentWidth - (float)$this$with.getWidth() - DraggableUtils.marginEnd($this$with)) {
                    float targetDockedX = (float)$this$with.getWidth() / (float)2 + DraggableUtils.marginEnd($this$with);
                    $this$with.animate().translationXBy(targetDockedX).start();
                }
                this.disableDrag();
                this.isMinimized = true;
                break;
            }
            case 2: {
                break;
            }
            default: {
                return;
            }
        }
    }

    private DraggableView(T targetView, Mode sticky, boolean animated, DraggableListener listener) {
        this.targetView = targetView;
        this.sticky = Mode.NON_STICKY;
        this.animated = true;
        this.setSticky(sticky);
        this.setAnimated(animated);
        this.setListener(listener);
        this.enableDrag();
    }

    public /* synthetic */ DraggableView(View targetView, Mode sticky, boolean animated, DraggableListener listener, DefaultConstructorMarker $constructor_marker) {
        this(targetView, sticky, animated, listener);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0010\u001a\u00020\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0013\u001a\u00020\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00028\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0014"}, d2={"Lio/github/hyuwah/draggableviewlib/DraggableView$Builder;", "VIEW", "Landroid/view/View;", "", "targetView", "(Landroid/view/View;)V", "animated", "", "listener", "Lio/github/hyuwah/draggableviewlib/DraggableListener;", "stickyMode", "Lio/github/hyuwah/draggableviewlib/DraggableView$Mode;", "Landroid/view/View;", "build", "Lio/github/hyuwah/draggableviewlib/DraggableView;", "setAnimated", "value", "setListener", "setStickyMode", "mode", "draggableviewlib_release"})
    public static final class Builder<VIEW extends View> {
        private Mode stickyMode;
        private boolean animated;
        private DraggableListener listener;
        private VIEW targetView;

        @NotNull
        public final Builder<VIEW> setStickyMode(@NotNull Mode mode) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.stickyMode = mode;
            return builder;
        }

        @NotNull
        public final Builder<VIEW> setAnimated(boolean value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.animated = value;
            return builder;
        }

        @NotNull
        public final Builder<VIEW> setListener(@Nullable DraggableListener listener) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.listener = listener;
            return builder;
        }

        @NotNull
        public final DraggableView<VIEW> build() {
            return new DraggableView((View)this.targetView, this.stickyMode, this.animated, this.listener, null);
        }

        public Builder(@NotNull VIEW targetView) {
            Intrinsics.checkNotNullParameter(targetView, (String)"targetView");
            this.targetView = targetView;
            this.stickyMode = Mode.NON_STICKY;
            this.animated = true;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/hyuwah/draggableviewlib/DraggableView$Mode;", "", "(Ljava/lang/String;I)V", "NON_STICKY", "STICKY_X", "STICKY_Y", "STICKY_XY", "draggableviewlib_release"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode NON_STICKY;
        public static final /* enum */ Mode STICKY_X;
        public static final /* enum */ Mode STICKY_Y;
        public static final /* enum */ Mode STICKY_XY;
        private static final /* synthetic */ Mode[] $VALUES;

        static {
            Mode[] modeArray = new Mode[4];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = NON_STICKY = new Mode();
            modeArray[1] = STICKY_X = new Mode();
            modeArray[2] = STICKY_Y = new Mode();
            modeArray[3] = STICKY_XY = new Mode();
            $VALUES = modeArray;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }
}

