/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.transport.junixsocket;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.transports.AbstractUnixTransport;
import org.freedesktop.dbus.exceptions.TransportConfigurationException;
import org.freedesktop.dbus.transport.junixsocket.JUnixSocketBusAddress;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.AFUNIXSocketExtensions;

public class JUnixSocketUnixTransport
extends AbstractUnixTransport {
    private final AFUNIXSocketAddress unixSocketAddress;
    private AFUNIXSocketChannel socket;
    private AFUNIXServerSocketChannel serverSocket;

    public JUnixSocketUnixTransport(JUnixSocketBusAddress _address, TransportConfig _config) throws TransportConfigurationException {
        super((BusAddress)_address, _config);
        StringBuilder path = new StringBuilder();
        if (_address.isAbstract()) {
            if (!AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_ABSTRACT_NAMESPACE)) {
                throw new TransportConfigurationException("Abstract unix addresses not supported by current os");
            }
            path.append('\u0000');
            path.append(_address.getAbstract());
        } else if (_address.hasPath()) {
            path.append(_address.getPath());
        } else {
            throw new TransportConfigurationException("Unix socket url has to specify 'path' or 'abstract'");
        }
        try {
            this.unixSocketAddress = AFUNIXSocketAddress.of((byte[])path.toString().getBytes(Charset.defaultCharset()));
        }
        catch (SocketException _ex) {
            throw new TransportConfigurationException("Unable to resolve unix socket _address", (Throwable)_ex);
        }
        this.getSaslConfig().setAuthMode(1);
    }

    protected boolean hasFileDescriptorSupport() {
        return AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_FILE_DESCRIPTORS) && AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_UNSAFE);
    }

    protected SocketChannel connectImpl() throws IOException {
        if (this.getAddress().isListeningSocket()) {
            throw new IOException("Connect connect to a listening socket (use listenImpl() instead)");
        }
        this.socket = AFUNIXSocketChannel.open();
        this.socket.configureBlocking(true);
        this.socket.connect((SocketAddress)this.unixSocketAddress);
        this.socket.setAncillaryReceiveBufferSize(1024);
        return this.socket;
    }

    public int getUid(SocketChannel _sock) throws IOException {
        if (_sock instanceof AFUNIXSocketExtensions) {
            AFUNIXSocketExtensions afext = (AFUNIXSocketExtensions)_sock;
            AFUNIXSocketCredentials peerCredentials = afext.getPeerCredentials();
            return (int)peerCredentials.getUid();
        }
        throw new IllegalArgumentException("Unable to handle unknown socket type: " + String.valueOf(_sock.getClass()));
    }

    protected void bindImpl() throws IOException {
        if (!this.getAddress().isListeningSocket()) {
            throw new IOException("Cannot listen on a client connection (use connectImpl() instead)");
        }
        if (!this.isBound()) {
            this.serverSocket = AFUNIXServerSocketChannel.open();
            this.serverSocket.configureBlocking(true);
            this.serverSocket.bind((SocketAddress)this.unixSocketAddress);
        }
    }

    protected SocketChannel acceptImpl() throws IOException {
        this.socket = this.serverSocket.accept();
        this.socket.setAncillaryReceiveBufferSize(1024);
        return this.socket;
    }

    protected boolean isBound() {
        return this.serverSocket != null && this.serverSocket.isOpen();
    }

    protected void closeTransport() throws IOException {
        if (this.socket != null && this.socket.isOpen()) {
            this.socket.close();
        }
        if (this.serverSocket != null && this.serverSocket.isOpen()) {
            this.serverSocket.close();
            String p = this.unixSocketAddress.getPath();
            if (p != null && !p.startsWith("@")) {
                Files.deleteIfExists(Path.of(p, new String[0]));
            }
        }
    }
}

