/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.transport.junixsocket;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.spi.message.AbstractInputStreamMessageReader;
import org.freedesktop.dbus.spi.message.ISocketProvider;
import org.newsclub.net.unix.AFUNIXSocketChannel;

public class JUnixSocketMessageReader
extends AbstractInputStreamMessageReader {
    public JUnixSocketMessageReader(AFUNIXSocketChannel _socket, ISocketProvider _socketProviderImpl) {
        super((SocketChannel)_socket, _socketProviderImpl);
    }

    protected List<FileDescriptor> readFileDescriptors(SocketChannel _inputChannel) throws DBusException {
        if (_inputChannel instanceof AFUNIXSocketChannel) {
            AFUNIXSocketChannel afUnix = (AFUNIXSocketChannel)_inputChannel;
            try {
                java.io.FileDescriptor[] receivedFileDescriptors = afUnix.getReceivedFileDescriptors();
                if (receivedFileDescriptors.length == 0) {
                    return null;
                }
                ArrayList<FileDescriptor> fds = new ArrayList<FileDescriptor>();
                for (java.io.FileDescriptor fd : receivedFileDescriptors) {
                    Optional fileDescriptorValue = this.getSocketProviderImpl().getFileDescriptorValue(fd);
                    fileDescriptorValue.ifPresent(f -> fds.add(new FileDescriptor(f.intValue())));
                }
                this.getLogger().debug("=> {}", fds);
                return fds;
            }
            catch (IOException _ex) {
                throw new DBusException("Cannot read file descriptors", (Throwable)_ex);
            }
        }
        return null;
    }
}

