/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.bluetooth.wrapper;

import com.github.hypfvieh.DbusHelper;
import com.github.hypfvieh.bluetooth.wrapper.AbstractBluetoothObject;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothAdapter;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDeviceType;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothGattService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bluez.Device1;
import org.bluez.GattService1;
import org.bluez.exceptions.BluezAlreadyConnectedException;
import org.bluez.exceptions.BluezAlreadyExistsException;
import org.bluez.exceptions.BluezAuthenticationCanceledException;
import org.bluez.exceptions.BluezAuthenticationFailedException;
import org.bluez.exceptions.BluezAuthenticationRejectedException;
import org.bluez.exceptions.BluezAuthenticationTimeoutException;
import org.bluez.exceptions.BluezConnectionAttemptFailedException;
import org.bluez.exceptions.BluezDoesNotExistException;
import org.bluez.exceptions.BluezFailedException;
import org.bluez.exceptions.BluezInProgressException;
import org.bluez.exceptions.BluezInvalidArgumentsException;
import org.bluez.exceptions.BluezNotAvailableException;
import org.bluez.exceptions.BluezNotConnectedException;
import org.bluez.exceptions.BluezNotReadyException;
import org.bluez.exceptions.BluezNotSupportedException;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;

public class BluetoothDevice
extends AbstractBluetoothObject {
    private final Device1 rawdevice;
    private final BluetoothAdapter adapter;
    private final AtomicBoolean servicesDiscovered = new AtomicBoolean();
    private final Map<String, BluetoothGattService> servicesByUuid = new LinkedHashMap<String, BluetoothGattService>();

    public BluetoothDevice(Device1 _device, BluetoothAdapter _adapter, String _dbusPath, DBusConnection _dbusConnection) {
        super(BluetoothDeviceType.DEVICE, _dbusConnection, _dbusPath);
        this.rawdevice = _device;
        this.adapter = _adapter;
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return Device1.class;
    }

    public List<BluetoothGattService> getGattServices() {
        if (!this.servicesDiscovered.get()) {
            this.refreshGattServices();
        }
        return new ArrayList<BluetoothGattService>(this.servicesByUuid.values());
    }

    public void refreshGattServices() {
        this.servicesDiscovered.set(true);
        this.servicesByUuid.clear();
        Set<String> findNodes = DbusHelper.findNodes(this.getDbusConnection(), this.getDbusPath());
        Map<String, GattService1> remoteObjects = this.getRemoteObjects(findNodes, this.getDbusPath(), GattService1.class);
        for (Map.Entry<String, GattService1> entry : remoteObjects.entrySet()) {
            BluetoothGattService bluetoothGattService = new BluetoothGattService(entry.getValue(), this, entry.getKey(), this.getDbusConnection());
            this.servicesByUuid.put(bluetoothGattService.getUuid(), bluetoothGattService);
        }
    }

    public BluetoothGattService getGattServiceByUuid(String _uuid) {
        if (!this.servicesDiscovered.get()) {
            this.refreshGattServices();
        }
        return this.servicesByUuid.get(_uuid);
    }

    public BluetoothAdapter getAdapter() {
        return this.adapter;
    }

    public Device1 getRawDevice() {
        return this.rawdevice;
    }

    public Boolean isBlocked() {
        return this.getTyped("Blocked", Boolean.class);
    }

    public void setBlocked(Boolean _blocked) {
        this.setTyped("Blocked", _blocked);
    }

    public Boolean isTrusted() {
        return this.getTyped("Trusted", Boolean.class);
    }

    public void setTrusted(boolean _trusted) {
        this.setTyped("Trusted", _trusted);
    }

    public String getAlias() {
        return this.getTyped("Alias", String.class);
    }

    public void setAlias(String _alias) {
        this.setTyped("Alias", _alias);
    }

    public byte[] getAdvertisingFlags() {
        List typed = this.getTyped("AdvertisingFlags", ArrayList.class);
        if (typed != null) {
            return this.byteListToByteArray(typed);
        }
        return null;
    }

    public String[] getUuids() {
        List typed = this.getTyped("UUIDs", ArrayList.class);
        if (typed != null) {
            return typed.toArray(new String[0]);
        }
        return null;
    }

    public Boolean isConnected() {
        return this.getTyped("Connected", Boolean.class);
    }

    public Boolean isLegacyPairing() {
        return this.getTyped("LegacyPairing", Boolean.class);
    }

    public Boolean isPaired() {
        return this.getTyped("Paired", Boolean.class);
    }

    public Boolean isServicesResolved() {
        return this.getTyped("ServicesResolved", Boolean.class);
    }

    public Map<String, byte[]> getServiceData() {
        return this.getTyped("ServiceData", LinkedHashMap.class);
    }

    public Map<UInt16, byte[]> getManufacturerData() {
        return this.getTyped("ManufacturerData", LinkedHashMap.class);
    }

    public Short getRssi() {
        return this.getTyped("RSSI", Short.class);
    }

    public Short getTxPower() {
        return this.getTyped("TxPower", Short.class);
    }

    public String getAddress() {
        return this.getTyped("Address", String.class);
    }

    public String getIcon() {
        return this.getTyped("Icon", String.class);
    }

    public String getModAlias() {
        return this.getTyped("Modalias", String.class);
    }

    public String getName() {
        String name = null;
        try {
            name = this.getTyped("Name", String.class);
        }
        catch (DBusExecutionException dBusExecutionException) {
            // empty catch block
        }
        if (name == null) {
            name = this.getAlias();
        }
        return name;
    }

    public Integer getAppearance() {
        UInt16 typed = this.getTyped("Appearance", UInt16.class);
        return typed != null ? Integer.valueOf(typed.intValue()) : null;
    }

    public Integer getBluetoothClass() {
        UInt32 typed = this.getTyped("Class", UInt32.class);
        return typed != null ? Integer.valueOf(typed.intValue()) : null;
    }

    public boolean connect() {
        try {
            this.rawdevice.Connect();
        }
        catch (BluezNotReadyException bluezNotReadyException) {
        }
        catch (BluezFailedException bluezFailedException) {
        }
        catch (BluezAlreadyConnectedException _ex) {
            return true;
        }
        catch (BluezInProgressException _ex) {
            return false;
        }
        return this.isConnected();
    }

    public boolean disconnect() {
        try {
            this.rawdevice.Disconnect();
            return true;
        }
        catch (BluezNotConnectedException bluezNotConnectedException) {
            return this.isConnected() == false;
        }
    }

    public boolean connectProfile(String _uuid) {
        try {
            this.rawdevice.ConnectProfile(_uuid);
            return true;
        }
        catch (BluezFailedException | BluezInProgressException | BluezInvalidArgumentsException | BluezNotAvailableException | BluezNotReadyException _ex) {
            return false;
        }
    }

    public boolean disconnectProfile(String _uuid) {
        try {
            this.rawdevice.DisconnectProfile(_uuid);
        }
        catch (BluezFailedException | BluezInProgressException | BluezInvalidArgumentsException | BluezNotSupportedException _ex) {
            return false;
        }
        return true;
    }

    public boolean pair() {
        try {
            this.rawdevice.Pair();
            return true;
        }
        catch (BluezAlreadyExistsException | BluezAuthenticationCanceledException | BluezAuthenticationFailedException | BluezAuthenticationRejectedException | BluezAuthenticationTimeoutException | BluezConnectionAttemptFailedException | BluezFailedException | BluezInvalidArgumentsException _ex) {
            return false;
        }
    }

    public boolean cancelPairing() {
        try {
            this.rawdevice.CancelPairing();
            return true;
        }
        catch (BluezDoesNotExistException | BluezFailedException _ex) {
            return false;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [device=" + String.valueOf(this.rawdevice) + ", adapter=" + this.adapter.getDbusPath() + ", getBluetoothType()=" + this.getBluetoothType().name() + ", getDbusPath()=" + this.getDbusPath() + "]";
    }
}

