/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.bluetooth.wrapper;

import com.github.hypfvieh.bluetooth.wrapper.AbstractBluetoothObject;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDevice;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDeviceType;
import org.bluez.Battery1;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;

public class BluetoothBattery
extends AbstractBluetoothObject {
    private final Battery1 rawbattery;
    private final BluetoothDevice device;

    public BluetoothBattery(Battery1 _battery, BluetoothDevice _device, String _dbusPath, DBusConnection _dbusConnection) {
        super(BluetoothDeviceType.BATTERY, _dbusConnection, _dbusPath);
        this.rawbattery = _battery;
        this.device = _device;
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return Battery1.class;
    }

    public BluetoothDevice getDevice() {
        return this.device;
    }

    public Battery1 getRawBattery() {
        return this.rawbattery;
    }

    public Byte getPercentage() {
        return this.getTyped("Percentage", Byte.class);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [battery=" + String.valueOf(this.rawbattery) + ", device=" + this.device.getDbusPath() + ", getBluetoothType()=" + this.getBluetoothType().name() + ", getDbusPath()=" + this.getDbusPath() + "]";
    }
}

