/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.bluetooth.wrapper;

import com.github.hypfvieh.DbusHelper;
import com.github.hypfvieh.bluetooth.wrapper.AbstractBluetoothObject;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDeviceType;
import org.bluez.AgentManager1;
import org.bluez.exceptions.BluezAlreadyExistsException;
import org.bluez.exceptions.BluezDoesNotExistException;
import org.bluez.exceptions.BluezInvalidArgumentsException;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentManager
extends AbstractBluetoothObject {
    private static final Logger logger = LoggerFactory.getLogger(AgentManager.class);
    private final AgentManager1 rawAgentManager;

    public AgentManager(DBusConnection _dbusConnection) {
        super(BluetoothDeviceType.AGENT_MANAGER, _dbusConnection, "/org/bluez");
        this.rawAgentManager = DbusHelper.getRemoteObject(_dbusConnection, this.getDbusPath(), AgentManager1.class);
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return AgentManager1.class;
    }

    public boolean registerAgent(String path, String capability) {
        try {
            this.rawAgentManager.RegisterAgent(new DBusPath(path), capability);
            return true;
        }
        catch (BluezAlreadyExistsException e) {
            logger.debug("Agent already exists (Path: {}).", (Object)path, (Object)e);
            return true;
        }
        catch (BluezInvalidArgumentsException e) {
            logger.error("Error while registering Agent (Path: {}).", (Object)path, (Object)e);
            return false;
        }
    }

    public boolean requestDefaultAgent(String path) {
        try {
            this.rawAgentManager.RequestDefaultAgent(new DBusPath(path));
            return true;
        }
        catch (BluezDoesNotExistException e) {
            logger.trace("Profile does not exist (Path: {}).", (Object)path, (Object)e);
            return false;
        }
    }

    public boolean unregisterAgent(String path) {
        try {
            this.rawAgentManager.UnregisterAgent(new DBusPath(path));
            return true;
        }
        catch (BluezDoesNotExistException e) {
            logger.trace("Profile does not exist (Path: {}).", (Object)path, (Object)e);
            return false;
        }
    }
}

