/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.bluetooth.wrapper;

import com.github.hypfvieh.bluetooth.wrapper.AbstractBluetoothObject;
import com.github.hypfvieh.bluetooth.wrapper.AgentChangeListener;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDeviceType;
import org.bluez.Agent1;
import org.bluez.exceptions.BluezCanceledException;
import org.bluez.exceptions.BluezRejectedException;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;

public final class AgentHandler
extends AbstractBluetoothObject
implements Agent1 {
    private final AgentChangeListener agentChangeListener;

    public AgentHandler(String _dbusPath, DBusConnection _dbusConnection, AgentChangeListener agentChangeListener) {
        super(BluetoothDeviceType.AGENT, _dbusConnection, _dbusPath);
        this.agentChangeListener = agentChangeListener;
    }

    @Override
    public void AuthorizeService(DBusPath _device, String _uuid) throws BluezRejectedException, BluezCanceledException {
        this.agentChangeListener.onAgentAuthorizeService(_device.getPath(), _uuid);
    }

    @Override
    public void Cancel() {
        this.agentChangeListener.onAgentCancel();
    }

    @Override
    public void DisplayPasskey(DBusPath _device, UInt32 _passkey, UInt16 _entered) {
        this.agentChangeListener.onAgentDisplayPassKey(_device.getPath(), _passkey.longValue(), _entered.intValue());
    }

    @Override
    public void DisplayPinCode(DBusPath _device, String _pincode) throws BluezRejectedException, BluezCanceledException {
        this.agentChangeListener.onAgentDisplayPinCode(_device.getPath(), _pincode);
    }

    @Override
    public void Release() {
        this.agentChangeListener.onAgentRelease();
    }

    @Override
    public void RequestAuthorization(DBusPath _device) throws BluezRejectedException, BluezCanceledException {
        this.agentChangeListener.onAgentRequestAuthorization(_device.getPath());
    }

    @Override
    public void RequestConfirmation(DBusPath _device, UInt32 _passkey) throws BluezRejectedException, BluezCanceledException {
        this.agentChangeListener.onAgentRequestConfirmation(_device.getPath(), _passkey.longValue());
    }

    @Override
    public UInt32 RequestPasskey(DBusPath _device) throws BluezRejectedException, BluezCanceledException {
        return new UInt32(this.agentChangeListener.onAgentRequestPassKey(_device.getPath()));
    }

    @Override
    public String RequestPinCode(DBusPath _device) throws BluezRejectedException, BluezCanceledException {
        return this.agentChangeListener.onAgentRequestPinCode(_device.getPath());
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return Agent1.class;
    }

    public String getObjectPath() {
        return this.getDbusPath();
    }

    public boolean isRemote() {
        return false;
    }
}

